/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.JwtAuthenticationFilter;
import cronapp.framework.security.JwtAuthenticationTokenFilter;
import jakarta.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JwtConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, JwtConfigurer<H>, JwtAuthenticationFilter> {
    public JwtConfigurer() {
        super((AbstractAuthenticationProcessingFilter)new JwtAuthenticationFilter(), "/auth");
    }

    public void init(H http) throws Exception {
        super.init(http);
        http.addFilterBefore((Filter)this.getAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore((Filter)new JwtAuthenticationTokenFilter(), UsernamePasswordAuthenticationFilter.class);
    }

    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl, "POST");
    }
}

