/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.OAuthProperties;
import cronapp.framework.security.OAuthRegistrationProperties;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.oauth", name={"enabled"}, havingValue="true")
public class OAuthAuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final DefaultOAuth2AuthorizationRequestResolver defaultResolver;

    public OAuthAuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository, OAuthProperties properties) {
        String authorizationRequestBaseUri = "/oauth2/authorization";
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, authorizationRequestBaseUri);
        this.defaultResolver.setAuthorizationRequestCustomizer(authorizationRequest -> {
            Object registrationId = authorizationRequest.build().getAttribute("registration_id");
            Boolean removeNonce = properties.getRegistrations().stream().filter(r -> r.getName().equals(registrationId)).map(OAuthRegistrationProperties::isRemoveNonce).findFirst().orElse(false);
            if (removeNonce.booleanValue()) {
                authorizationRequest.attributes(attrs -> attrs.remove("nonce"));
            }
        });
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.defaultResolver.resolve(request);
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.defaultResolver.resolve(request, clientRegistrationId);
    }
}

