/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC77")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S77")
public class AvoidRegexPatternNotStatic
extends IssuableSubscriptionVisitor {
    public static final String MESSAGE_RULE = "Avoid using Pattern.compile() in a non-static context.";
    private static final MethodMatchers PATTERN_COMPILE = MethodMatchers.create().ofTypes(new String[]{Pattern.class.getName()}).names(new String[]{"compile"}).withAnyParameters().build();
    private final AvoidRegexPatternNotStaticVisitor visitor = new AvoidRegexPatternNotStaticVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(@Nonnull Tree tree) {
        if (tree instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)tree;
            if (!methodTree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                methodTree.accept((TreeVisitor)this.visitor);
            }
        }
    }

    private class AvoidRegexPatternNotStaticVisitor
    extends BaseTreeVisitor {
        private AvoidRegexPatternNotStaticVisitor() {
        }

        public void visitMethodInvocation(@Nonnull MethodInvocationTree tree) {
            if (PATTERN_COMPILE.matches(tree)) {
                AvoidRegexPatternNotStatic.this.reportIssue((Tree)tree, AvoidRegexPatternNotStatic.MESSAGE_RULE);
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

