/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.google.common.base.Preconditions;
import io.getstream.cloud.CloudClient;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Data;
import io.getstream.core.models.ProfileData;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class CloudUser {
    private final CloudClient client;
    private final String id;

    public CloudUser(CloudClient client, String id) {
        Preconditions.checkNotNull((Object)client, (Object)"Client can't be null");
        Preconditions.checkNotNull((Object)id, (Object)"User ID can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"User ID can't be empty");
        this.client = client;
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public CompletableFuture<Data> get() throws StreamException {
        return this.client.getUser(this.id).thenApply(response -> {
            try {
                return Serialization.deserialize(response, Data.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> delete() throws StreamException {
        return this.client.deleteUser(this.id).thenApply(response -> {
            try {
                return Serialization.deserializeError(response);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Data> getOrCreate(Data data) throws StreamException {
        return this.client.getOrCreateUser(this.id, data).thenApply(response -> {
            try {
                return Serialization.deserialize(response, Data.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Data> create(Data data) throws StreamException {
        return this.client.createUser(this.id, data).thenApply(response -> {
            try {
                return Serialization.deserialize(response, Data.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Data> update(Data data) throws StreamException {
        return this.client.updateUser(this.id, data).thenApply(response -> {
            try {
                return Serialization.deserialize(response, Data.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<ProfileData> profile() throws StreamException {
        return this.client.userProfile(this.id).thenApply(response -> {
            try {
                return Serialization.deserialize(response, ProfileData.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

