/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Group<T> {
    private final String group;
    private final List<T> activities;
    private final int actorCount;
    private final Date createdAt;
    private final Date updatedAt;

    @JsonCreator
    public Group(@JsonProperty(value="group") String group, @JsonProperty(value="activities") List<T> activities, @JsonProperty(value="actor_count") int actorCount, @JsonProperty(value="created_at") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.S", timezone="UTC") Date createdAt, @JsonProperty(value="updated_at") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.S", timezone="UTC") Date updatedAt) {
        Preconditions.checkNotNull((Object)group, (Object)"Group 'group' field required");
        Preconditions.checkNotNull(activities, (Object)"Group 'activities' field required");
        this.group = group;
        this.activities = activities;
        this.actorCount = actorCount;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public String getGroup() {
        return this.group;
    }

    public List<T> getActivities() {
        return this.activities;
    }

    public int getActorCount() {
        return this.actorCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group that = (Group)o;
        return this.actorCount == that.actorCount && Objects.equals(this.group, that.group) && Objects.equals(this.activities, that.activities) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.activities, this.actorCount, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activities", this.activities).add("actorCount", this.actorCount).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).toString();
    }
}

