/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.models.Engagement;
import io.getstream.core.models.Impression;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public final class StreamAnalytics {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamAnalytics(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Void> trackEngagement(Token token, final Engagement ... events) throws StreamException {
        Preconditions.checkNotNull((Object)events, (Object)"No events to track");
        Preconditions.checkArgument((events.length > 0 ? 1 : 0) != 0, (Object)"No events to track");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Engagement[] content_list;
                {
                    this.content_list = events;
                }
            });
            URL url = Routes.buildAnalyticsURL(this.baseURL, "engagement/");
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> trackImpression(Token token, Impression event) throws StreamException {
        Preconditions.checkNotNull((Object)event, (Object)"No events to track");
        try {
            byte[] payload = Serialization.toJSON(event);
            URL url = Routes.buildAnalyticsURL(this.baseURL, "impression/");
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException((Throwable)e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public URL createRedirectURL(Token token, URL url, Impression[] impressions, Engagement[] engagements) throws StreamException {
        try {
            byte[] events = Serialization.toJSON(ObjectArrays.concat((Object[])impressions, (Object[])engagements, Object.class));
            return HTTPClient.requestBuilder().url(Routes.buildAnalyticsURL(this.baseURL, "redirect/")).addQueryParameter("api_key", this.key).addQueryParameter("url", url.toExternalForm()).addQueryParameter("events", new String(events, Charsets.UTF_8)).addQueryParameter("auth_type", "jwt").addQueryParameter("authorization", token.toString()).build().getURL();
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

