/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.core.exceptions.StreamException;

public class QueryAuditLogsFilters {
    private String entityType;
    private String entityID;
    private String userID;

    private QueryAuditLogsFilters() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryAuditLogsFilters forUser(String userID) {
        return QueryAuditLogsFilters.builder().withUserID(userID).build();
    }

    public static QueryAuditLogsFilters forEntity(String entityType, String entityID) {
        return QueryAuditLogsFilters.builder().withEntityType(entityType).withEntityID(entityID).build();
    }

    public static QueryAuditLogsFilters forActivity(String activityID) {
        return QueryAuditLogsFilters.forEntity("activity", activityID);
    }

    public static QueryAuditLogsFilters forReaction(String reactionID) {
        return QueryAuditLogsFilters.forEntity("reaction", reactionID);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getUserID() {
        return this.userID;
    }

    public QueryAuditLogsFilters setEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    public QueryAuditLogsFilters setEntityID(String entityID) {
        this.entityID = entityID;
        return this;
    }

    public QueryAuditLogsFilters setUserID(String userID) {
        this.userID = userID;
        return this;
    }

    public void validate() throws StreamException {
        boolean hasUserID;
        boolean hasEntityFields = this.entityType != null && !this.entityType.isEmpty() && this.entityID != null && !this.entityID.isEmpty();
        boolean bl = hasUserID = this.userID != null && !this.userID.isEmpty();
        if (!hasEntityFields && !hasUserID) {
            throw new StreamException("Either entityType+entityID or userID is required for audit logs queries");
        }
    }

    public boolean isValid() {
        boolean hasEntityFields = this.entityType != null && !this.entityType.isEmpty() && this.entityID != null && !this.entityID.isEmpty();
        boolean hasUserID = this.userID != null && !this.userID.isEmpty();
        return hasEntityFields || hasUserID;
    }

    public static class Builder {
        private final QueryAuditLogsFilters filters = new QueryAuditLogsFilters();

        private Builder() {
        }

        public Builder withEntityType(String entityType) {
            this.filters.entityType = entityType;
            return this;
        }

        public Builder withEntityID(String entityID) {
            this.filters.entityID = entityID;
            return this;
        }

        public Builder withUserID(String userID) {
            this.filters.userID = userID;
            return this;
        }

        public QueryAuditLogsFilters build() {
            return this.filters;
        }
    }
}

