/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.getstream.core.LookupKind;
import io.getstream.core.StreamReactions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.Reaction;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import java.util.List;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;

public final class CloudReactionsClient {
    private final Token token;
    private final String userID;
    private final StreamReactions reactions;

    CloudReactionsClient(Token token, String userID, StreamReactions reactions) {
        this.token = token;
        this.userID = userID;
        this.reactions = reactions;
    }

    public CompletableFuture<Reaction> get(String id) throws StreamException {
        return this.reactions.get(this.token, id);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id) throws StreamException {
        Params params = new Params(lookup, id);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Limit limit) throws StreamException {
        Params params = new Params(lookup, id).withLimit(limit);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter) throws StreamException {
        Params params = new Params(lookup, id).withFilter(filter);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, String kind) throws StreamException {
        Params params = new Params(lookup, id).withKind(kind);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter, Limit limit) throws StreamException {
        Params params = new Params(lookup, id).withFilter(filter).withLimit(limit);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Limit limit, String kind) throws StreamException {
        Params params = new Params(lookup, id).withLimit(limit).withKind(kind);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter, Limit limit, String kind) throws StreamException {
        Params params = new Params(lookup, id).withLimit(limit).withKind(kind).withFilter(filter).withLimit(limit);
        return this.filter(params);
    }

    public CompletableFuture<List<Reaction>> filter(LookupKind lookup, String id, Filter filter, Limit limit, String kind, Boolean includeOwnChildren) throws StreamException {
        Params params = new Params(lookup, id).withLimit(limit).withKind(kind).withFilter(filter).withLimit(limit).includeOwnChildren(includeOwnChildren);
        return this.filter(params);
    }

    private CompletableFuture<List<Reaction>> filter(Params params) throws StreamException {
        return this.reactions.filter(this.token, params.getLookupKind(), params.getId(), params.getFilter(), params.getLimit(), params.getKind(), params.getWithOwnChildren(), "");
    }

    public CompletableFuture<Reaction> add(String kind, String activityID, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(this.userID, kind, activityID, targetFeeds);
    }

    public CompletableFuture<Reaction> add(String kind, String activityID, FeedID ... targetFeeds) throws StreamException {
        return this.add(this.userID, activityID, targetFeeds);
    }

    public CompletableFuture<Reaction> add(Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(this.userID, reaction, targetFeeds);
    }

    public CompletableFuture<Reaction> add(Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        return this.add(this.userID, reaction, targetFeeds);
    }

    public CompletableFuture<Reaction> add(String userID, String kind, String activityID, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(userID, kind, activityID, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Reaction> add(String userID, String kind, String activityID, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)kind, (Object)"Reaction kind can't be null");
        Preconditions.checkArgument((!kind.isEmpty() ? 1 : 0) != 0, (Object)"Reaction kind can't be empty");
        Preconditions.checkNotNull((Object)activityID, (Object)"Reaction activity id can't be null");
        Preconditions.checkArgument((!activityID.isEmpty() ? 1 : 0) != 0, (Object)"Reaction activity id can't be empty");
        return this.add(userID, Reaction.builder().activityID(activityID).kind(kind).build(), targetFeeds);
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.add(userID, reaction, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        return this.reactions.add(this.token, userID, reaction, targetFeeds);
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, FeedID[] targetFeeds, RequestOption ... options) throws StreamException {
        return this.reactions.add(this.token, userID, reaction, targetFeeds, null, options);
    }

    public CompletableFuture<Reaction> add(String userID, Reaction reaction, FeedID[] targetFeeds, Map<String, Object> targetFeedsExtraData, RequestOption ... options) throws StreamException {
        return this.reactions.add(this.token, userID, reaction, targetFeeds, targetFeedsExtraData, options);
    }

    public CompletableFuture<Reaction> addChild(String userID, String kind, String parentID, Iterable<FeedID> targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().kind(kind).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String kind, String parentID, FeedID ... targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().kind(kind).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String kind, String parentID, FeedID[] targetFeeds, Map<String, Object> targetFeedsExtraData) throws StreamException {
        Reaction child = Reaction.builder().kind(kind).parent(parentID).build();
        return this.add(userID, child, targetFeeds, targetFeedsExtraData, new RequestOption[0]);
    }

    public CompletableFuture<Reaction> addChild(String userID, String parentID, Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().fromReaction(reaction).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String parentID, Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        Reaction child = Reaction.builder().fromReaction(reaction).parent(parentID).build();
        return this.add(userID, child, targetFeeds);
    }

    public CompletableFuture<Reaction> addChild(String userID, String parentID, Reaction reaction, FeedID[] targetFeeds, Map<String, Object> targetFeedsExtraData) throws StreamException {
        Reaction child = Reaction.builder().fromReaction(reaction).parent(parentID).build();
        return this.add(userID, child, targetFeeds, targetFeedsExtraData, new RequestOption[0]);
    }

    public CompletableFuture<Void> update(String id, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.update(id, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Void> update(String id, FeedID ... targetFeeds) throws StreamException {
        Preconditions.checkNotNull((Object)id, (Object)"Reaction id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Reaction id can't be empty");
        return this.update(Reaction.builder().id(id).build(), targetFeeds);
    }

    public CompletableFuture<Void> update(Reaction reaction, Iterable<FeedID> targetFeeds) throws StreamException {
        return this.update(reaction, (FeedID[])Iterables.toArray(targetFeeds, FeedID.class));
    }

    public CompletableFuture<Void> update(Reaction reaction, FeedID ... targetFeeds) throws StreamException {
        return this.reactions.update(this.token, reaction, targetFeeds);
    }

    public CompletableFuture<Void> update(Reaction reaction, FeedID[] targetFeeds, RequestOption ... options) throws StreamException {
        return this.reactions.update(this.token, reaction, targetFeeds, options);
    }

    public CompletableFuture<Void> delete(String id) throws StreamException {
        return this.reactions.delete(this.token, id, false);
    }

    public CompletableFuture<Void> delete(String id, Boolean soft) throws StreamException {
        return this.reactions.delete(this.token, id, soft);
    }

    public CompletableFuture<Void> softDelete(String id) throws StreamException {
        return this.reactions.delete(this.token, id, true);
    }

    public CompletableFuture<Void> restore(String id) throws StreamException {
        return this.reactions.restore(this.token, id);
    }

    public class Params {
        private LookupKind lookupKind;
        private String id;
        private Filter filter;
        private Limit limit;
        private String kind;
        private Boolean withOwnChildren;

        public Params(LookupKind lookupKind, String id) {
            this.id = id;
            this.lookupKind = lookupKind;
        }

        public Params withLimit(Limit limit) {
            this.limit = limit;
            return this;
        }

        public Params withFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Params withKind(String kind) {
            this.kind = kind;
            return this;
        }

        public Params includeOwnChildren(Boolean includeOwnChildren) {
            this.withOwnChildren = includeOwnChildren;
            return this;
        }

        public LookupKind getLookupKind() {
            return this.lookupKind;
        }

        public String getId() {
            return this.id;
        }

        public Filter getFilter() {
            return this.filter != null ? this.filter : DefaultOptions.DEFAULT_FILTER;
        }

        public Limit getLimit() {
            return this.limit != null ? this.limit : DefaultOptions.DEFAULT_LIMIT;
        }

        public String getKind() {
            return this.kind != null ? this.kind : "";
        }

        public Boolean getWithOwnChildren() {
            return this.withOwnChildren != null ? this.withOwnChildren : false;
        }
    }
}

