/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.List;

public final class DiscardActors
implements RequestOption {
    private final String actors;
    private final String separator;

    public DiscardActors(String ... actors) {
        this(actors, ",");
    }

    public DiscardActors(List<String> actors) {
        this(actors, ",");
    }

    public DiscardActors(String[] actors, String separator) {
        Preconditions.checkNotNull((Object)actors, (Object)"Actors list cannot be null");
        this.actors = String.join((CharSequence)(separator != null ? separator : ","), actors);
        this.separator = separator;
    }

    public DiscardActors(List<String> actors, String separator) {
        Preconditions.checkNotNull(actors, (Object)"Actors list cannot be null");
        this.actors = String.join((CharSequence)(separator != null ? separator : ","), actors);
        this.separator = separator;
    }

    @Override
    public void apply(Request.Builder builder) {
        if (this.actors != null && !this.actors.isEmpty()) {
            builder.addQueryParameter("discard_actors", this.actors);
            if (this.separator != null && !this.separator.equals(",")) {
                builder.addQueryParameter("discard_actors_sep", this.separator);
            }
        }
    }
}

