/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.getstream.core.exceptions.StreamAPIException;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Type;
import java.util.List;

public final class Serialization {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Range<Integer> normalResponseCodes = Range.closed((Comparable)Integer.valueOf(200), (Comparable)Integer.valueOf(299));

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    public void setObjectMapper(ObjectMapper mapper) {
        Serialization.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"Missing object mapper");
    }

    private Serialization() {
    }

    public static <T> byte[] toJSON(T obj) throws JsonProcessingException {
        return mapper.writeValueAsBytes(obj);
    }

    public static <T> T fromJSON(InputStream json, Class<T> type) throws IOException {
        return (T)mapper.readValue(json, type);
    }

    public static <T> T fromJSON(InputStream json, TypeReference<T> type) throws IOException {
        return (T)mapper.readValue(json, type);
    }

    public static <T> T fromJSON(InputStream json, String wrapper, JavaType type) throws IOException {
        JsonNode tree = mapper.readTree(json);
        for (String path : wrapper.split("\\.")) {
            tree = tree.findPath(path);
        }
        return (T)mapper.readValue(mapper.treeAsTokens((TreeNode)tree), type);
    }

    public static <T> T fromJSON(String json, Class<T> type) throws IOException {
        return (T)mapper.readValue(json, type);
    }

    public static <T> List<T> fromJSONList(String json, Class<T> type) throws IOException {
        CollectionType collection = mapper.getTypeFactory().constructCollectionType(List.class, type);
        return (List)mapper.readValue(json, (JavaType)collection);
    }

    public static <T, U> T convert(U obj, Class<T> type) {
        return (T)mapper.convertValue(obj, type);
    }

    public static <T, U> T convert(U obj, TypeReference<T> type) {
        return (T)mapper.convertValue(obj, type);
    }

    public static <T> List<T> deserializeContainer(Response response, Class<T> type) throws IOException, StreamException {
        return Serialization.deserializeContainer(response, "results", type);
    }

    public static <T> T deserializeContainer(Response response, Class<?> wrapperType, Class<?> ... types) throws IOException, StreamException {
        JavaType wrappedType = mapper.getTypeFactory().constructParametricType(wrapperType, (Class[])types);
        return Serialization.deserializeContainer(response, "results", wrappedType);
    }

    public static <T> List<T> deserializeContainer(Response response, String wrapper, Class<T> element) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            CollectionType collection = mapper.getTypeFactory().constructCollectionType(List.class, element);
            return (List)Serialization.fromJSON(response.getBody(), wrapper, mapper.getTypeFactory().constructType((Type)collection));
        }
        throw Serialization.deserializeException(response);
    }

    public static <T> T deserializeContainerSingleItem(Response response, Class<T> element) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            return Serialization.fromJSON(response.getBody(), "results", mapper.getTypeFactory().constructType(element));
        }
        throw Serialization.deserializeException(response);
    }

    public static <T> T deserializeContainer(Response response, String wrapper, JavaType element) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            CollectionType collection = mapper.getTypeFactory().constructCollectionType(List.class, element);
            return Serialization.fromJSON(response.getBody(), wrapper, mapper.getTypeFactory().constructType((Type)collection));
        }
        throw Serialization.deserializeException(response);
    }

    public static <T> T deserialize(Response response, String wrapper, Class<T> type) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            return Serialization.fromJSON(response.getBody(), wrapper, mapper.getTypeFactory().constructType(type));
        }
        throw Serialization.deserializeException(response);
    }

    public static <T> T deserialize(Response response, Class<T> type) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            return Serialization.fromJSON(response.getBody(), type);
        }
        throw Serialization.deserializeException(response);
    }

    public static <T> T deserialize(Response response, TypeReference<T> type) throws IOException, StreamException {
        if (normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            return Serialization.fromJSON(response.getBody(), type);
        }
        throw Serialization.deserializeException(response);
    }

    public static Void deserializeError(Response response) throws IOException, StreamException {
        if (!normalResponseCodes.contains((Comparable)Integer.valueOf(response.getCode()))) {
            throw Serialization.deserializeException(response);
        }
        return null;
    }

    private static StreamAPIException deserializeException(Response response) throws IOException {
        try (PushbackInputStream wrapper = new PushbackInputStream(response.getBody());){
            int read = wrapper.read();
            if (read == -1) {
                StreamAPIException streamAPIException = new StreamAPIException(null, 0, response.getCode(), "API Error");
                return streamAPIException;
            }
            wrapper.unread(read);
            StreamAPIException streamAPIException = Serialization.fromJSON((InputStream)wrapper, StreamAPIException.class);
            return streamAPIException;
        }
    }
}

