/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.google.common.base.Preconditions;
import io.getstream.cloud.CloudAggregatedFeed;
import io.getstream.cloud.CloudAnalyticsClient;
import io.getstream.cloud.CloudCollectionsClient;
import io.getstream.cloud.CloudFileStorageClient;
import io.getstream.cloud.CloudFlatFeed;
import io.getstream.cloud.CloudImageStorageClient;
import io.getstream.cloud.CloudNotificationFeed;
import io.getstream.cloud.CloudReactionsClient;
import io.getstream.cloud.CloudUser;
import io.getstream.core.Region;
import io.getstream.core.Stream;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.OKHTTPClientAdapter;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.models.Activity;
import io.getstream.core.models.Data;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.OGData;
import io.getstream.core.options.RequestOption;
import java.net.MalformedURLException;
import java.net.URL;
import java8.util.concurrent.CompletableFuture;

public final class CloudClient {
    private final Token token;
    private final String userID;
    private final Stream stream;

    private CloudClient(String key, Token token, String userID, URL baseURL, HTTPClient httpClient) {
        this.token = token;
        this.userID = userID;
        this.stream = new Stream(key, baseURL, httpClient);
    }

    public static Builder builder(String apiKey, String token, String userID) {
        return new Builder(apiKey, new Token(token), userID);
    }

    public static Builder builder(String apiKey, Token token, String userID) {
        return new Builder(apiKey, token, userID);
    }

    public CompletableFuture<OGData> openGraph(URL url) throws StreamException {
        return this.stream.openGraph(this.token, url);
    }

    public <T> T getHTTPClientImplementation() {
        return this.stream.getHTTPClientImplementation();
    }

    public CloudFlatFeed flatFeed(String slug) {
        return this.flatFeed(slug, this.userID);
    }

    public CloudFlatFeed flatFeed(String slug, CloudUser user) {
        return this.flatFeed(slug, user.getID());
    }

    public CloudFlatFeed flatFeed(String slug, String userID) {
        return this.flatFeed(new FeedID(slug, userID));
    }

    public CloudFlatFeed flatFeed(FeedID id) {
        return new CloudFlatFeed(this, id);
    }

    public CloudAggregatedFeed aggregatedFeed(String slug) {
        return this.aggregatedFeed(slug, this.userID);
    }

    public CloudAggregatedFeed aggregatedFeed(String slug, CloudUser user) {
        return this.aggregatedFeed(slug, user.getID());
    }

    public CloudAggregatedFeed aggregatedFeed(String slug, String userID) {
        return this.aggregatedFeed(new FeedID(slug, userID));
    }

    public CloudAggregatedFeed aggregatedFeed(FeedID id) {
        return new CloudAggregatedFeed(this, id);
    }

    public CloudNotificationFeed notificationFeed(String slug) {
        return this.notificationFeed(slug, this.userID);
    }

    public CloudNotificationFeed notificationFeed(String slug, CloudUser user) {
        return this.notificationFeed(slug, user.getID());
    }

    public CloudNotificationFeed notificationFeed(String slug, String userID) {
        return this.notificationFeed(new FeedID(slug, userID));
    }

    public CloudNotificationFeed notificationFeed(FeedID id) {
        return new CloudNotificationFeed(this, id);
    }

    public CloudUser user(String userID) {
        return new CloudUser(this, userID);
    }

    public CloudAnalyticsClient analytics() {
        return new CloudAnalyticsClient(this.token, this.stream.analytics());
    }

    public CloudCollectionsClient collections() {
        return new CloudCollectionsClient(this.token, this.userID, this.stream.collections());
    }

    public CloudReactionsClient reactions() {
        return new CloudReactionsClient(this.token, this.userID, this.stream.reactions());
    }

    public CloudFileStorageClient files() {
        return new CloudFileStorageClient(this.token, this.stream.files());
    }

    public CloudImageStorageClient images() {
        return new CloudImageStorageClient(this.token, this.stream.images());
    }

    CompletableFuture<Response> getActivities(FeedID feed, RequestOption ... options) throws StreamException {
        return this.stream.getActivities(this.token, feed, options);
    }

    CompletableFuture<Response> getEnrichedActivities(FeedID feed, RequestOption ... options) throws StreamException {
        return this.stream.getEnrichedActivities(this.token, feed, options);
    }

    CompletableFuture<Response> addActivity(FeedID feed, Activity activity) throws StreamException {
        return this.stream.addActivity(this.token, feed, activity);
    }

    CompletableFuture<Response> addActivities(FeedID feed, Activity ... activities) throws StreamException {
        return this.stream.addActivities(this.token, feed, activities);
    }

    CompletableFuture<Response> removeActivityByID(FeedID feed, String id) throws StreamException {
        return this.stream.removeActivityByID(this.token, feed, id);
    }

    CompletableFuture<Response> removeActivityByForeignID(FeedID feed, String foreignID) throws StreamException {
        return this.stream.removeActivityByForeignID(this.token, feed, foreignID);
    }

    CompletableFuture<Response> follow(FeedID source, FeedID target, int activityCopyLimit) throws StreamException {
        return this.stream.follow(this.token, this.token, source, target, activityCopyLimit);
    }

    CompletableFuture<Response> getFollowers(FeedID feed, RequestOption ... options) throws StreamException {
        return this.stream.getFollowers(this.token, feed, options);
    }

    CompletableFuture<Response> getFollowed(FeedID feed, RequestOption ... options) throws StreamException {
        return this.stream.getFollowed(this.token, feed, options);
    }

    CompletableFuture<Response> unfollow(FeedID source, FeedID target, RequestOption ... options) throws StreamException {
        return this.stream.unfollow(this.token, source, target, options);
    }

    CompletableFuture<Response> getUser(String id) throws StreamException {
        return this.stream.getUser(this.token, id, false);
    }

    CompletableFuture<Response> deleteUser(String id) throws StreamException {
        return this.stream.deleteUser(this.token, id);
    }

    CompletableFuture<Response> getOrCreateUser(String id, Data data) throws StreamException {
        return this.stream.createUser(this.token, id, data, true);
    }

    CompletableFuture<Response> createUser(String id, Data data) throws StreamException {
        return this.stream.createUser(this.token, id, data, false);
    }

    CompletableFuture<Response> updateUser(String id, Data data) throws StreamException {
        return this.stream.updateUser(this.token, id, data);
    }

    CompletableFuture<Response> userProfile(String id) throws StreamException {
        return this.stream.getUser(this.token, id, true);
    }

    public static final class Builder {
        private static final String DEFAULT_HOST = "stream-io-api.com";
        private final String apiKey;
        private final Token token;
        private final String userID;
        private HTTPClient httpClient;
        private String scheme = "https";
        private String region = Region.US_EAST.toString();
        private String host = "stream-io-api.com";
        private int port = 443;

        public Builder(String apiKey, Token token, String userID) {
            Preconditions.checkNotNull((Object)apiKey, (Object)"API key can't be null");
            Preconditions.checkNotNull((Object)token, (Object)"Token can't be null");
            Preconditions.checkNotNull((Object)userID, (Object)"User ID can't be null");
            Preconditions.checkArgument((!apiKey.isEmpty() ? 1 : 0) != 0, (Object)"API key can't be empty");
            Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"User ID can't be empty");
            this.apiKey = apiKey;
            this.token = token;
            this.userID = userID;
        }

        public Builder httpClient(HTTPClient httpClient) {
            Preconditions.checkNotNull((Object)httpClient, (Object)"HTTP client can't be null");
            this.httpClient = httpClient;
            return this;
        }

        public Builder scheme(String scheme) {
            Preconditions.checkNotNull((Object)scheme, (Object)"Scheme can't be null");
            Preconditions.checkArgument((!scheme.isEmpty() ? 1 : 0) != 0, (Object)"Scheme can't be empty");
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            Preconditions.checkNotNull((Object)host, (Object)"Host can't be null");
            Preconditions.checkArgument((!host.isEmpty() ? 1 : 0) != 0, (Object)"Host can't be empty");
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port has to be a non-zero positive number");
            this.port = port;
            return this;
        }

        public Builder region(Region region) {
            Preconditions.checkNotNull((Object)((Object)region), (Object)"Region can't be null");
            this.region = region.toString();
            return this;
        }

        public Builder region(String region) {
            Preconditions.checkNotNull((Object)region, (Object)"Region can't be null");
            Preconditions.checkArgument((!region.isEmpty() ? 1 : 0) != 0, (Object)"Region can't be empty");
            this.region = region;
            return this;
        }

        private String buildHost() {
            StringBuilder sb = new StringBuilder();
            if (this.host.equals(DEFAULT_HOST)) {
                sb.append(this.region).append(".");
            }
            sb.append(this.host);
            return sb.toString();
        }

        public CloudClient build() throws MalformedURLException {
            if (this.httpClient == null) {
                this.httpClient = new OKHTTPClientAdapter();
            }
            return new CloudClient(this.apiKey, this.token, this.userID, new URL(this.scheme, this.buildHost(), this.port, ""), this.httpClient);
        }
    }
}

