/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import com.google.common.collect.ImmutableMap;
import io.getstream.core.StreamPersonalization;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.utils.Auth;
import java.util.Map;
import java8.util.concurrent.CompletableFuture;

public final class PersonalizationClient {
    private final String secret;
    private final StreamPersonalization personalization;

    PersonalizationClient(String secret, StreamPersonalization personalization) {
        this.secret = secret;
        this.personalization = personalization;
    }

    public CompletableFuture<Map<String, Object>> get(String resource) throws StreamException {
        return this.get(null, resource);
    }

    public CompletableFuture<Map<String, Object>> get(String resource, Map<String, Object> params) throws StreamException {
        return this.get(null, resource, params);
    }

    public CompletableFuture<Map<String, Object>> get(String userID, String resource) throws StreamException {
        return this.get(userID, resource, (Map<String, Object>)ImmutableMap.of());
    }

    public CompletableFuture<Map<String, Object>> get(String userID, String resource, Map<String, Object> params) throws StreamException {
        Token token = Auth.buildPersonalizationToken(this.secret, userID, Auth.TokenAction.READ);
        return this.personalization.get(token, userID, resource, params);
    }

    public CompletableFuture<Void> post(String resource, Map<String, Object> payload) throws StreamException {
        return this.post(null, resource, payload);
    }

    public CompletableFuture<Void> post(String resource, Map<String, Object> params, Map<String, Object> payload) throws StreamException {
        return this.post(null, resource, params, payload);
    }

    public CompletableFuture<Void> post(String userID, String resource, Map<String, Object> payload) throws StreamException {
        return this.post(userID, resource, (Map<String, Object>)ImmutableMap.of(), payload);
    }

    public CompletableFuture<Void> post(String userID, String resource, Map<String, Object> params, Map<String, Object> payload) throws StreamException {
        Token token = Auth.buildPersonalizationToken(this.secret, userID, Auth.TokenAction.WRITE);
        return this.personalization.post(token, userID, resource, params, payload);
    }

    public CompletableFuture<Void> delete(String resource) throws StreamException {
        return this.delete(null, resource);
    }

    public CompletableFuture<Void> delete(String resource, Map<String, Object> params) throws StreamException {
        return this.delete(null, resource, params);
    }

    public CompletableFuture<Void> delete(String userID, String resource) throws StreamException {
        return this.delete(userID, resource, (Map<String, Object>)ImmutableMap.of());
    }

    public CompletableFuture<Void> delete(String userID, String resource, Map<String, Object> params) throws StreamException {
        Token token = Auth.buildPersonalizationToken(this.secret, userID, Auth.TokenAction.DELETE);
        return this.personalization.delete(token, userID, resource, params);
    }
}

