/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class AccumulativeMappingWriter {
    private final Map<String, String> mappings = new ConcurrentHashMap<String, String>();
    private final String resourcePath;
    private final ProcessingEnvironment processingEnvironment;

    public AccumulativeMappingWriter(String resourcePath, ProcessingEnvironment processingEnvironment) {
        this.resourcePath = resourcePath;
        this.processingEnvironment = processingEnvironment;
    }

    public AccumulativeMappingWriter loadExistingMappings() {
        try {
            FileObject readonlyResource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.resourcePath);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(readonlyResource.openInputStream()));){
                Map<String, String> existingLines = bufferedReader.lines().map(l -> l.split(",")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
                this.mappings.putAll(existingLines);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public AccumulativeMappingWriter add(String key, String value) {
        this.mappings.put(key, value);
        return this;
    }

    public void flush() {
        try (PrintWriter printWriter = null;){
            FileObject resource = this.processingEnvironment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.resourcePath, new Element[0]);
            printWriter = new PrintWriter(resource.openOutputStream());
            for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
                printWriter.println(entry.getKey() + "," + entry.getValue());
            }
        }
    }
}

