/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.config.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.config.runtime.AnnotationControllerConfiguration;

public class DefaultConfigurationService
extends BaseConfigurationService {
    private static final DefaultConfigurationService instance = new DefaultConfigurationService();
    private boolean createIfNeeded = super.createIfNeeded();

    private DefaultConfigurationService() {
    }

    static DefaultConfigurationService instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler, boolean createIfNeeded) {
        boolean previous = this.createIfNeeded();
        this.setCreateIfNeeded(createIfNeeded);
        try {
            ControllerConfiguration controllerConfiguration = super.getConfigurationFor(reconciler);
            return controllerConfiguration;
        }
        finally {
            this.setCreateIfNeeded(previous);
        }
    }

    protected boolean createIfNeeded() {
        return this.createIfNeeded;
    }

    public void setCreateIfNeeded(boolean createIfNeeded) {
        this.createIfNeeded = createIfNeeded;
    }

    protected <R extends HasMetadata> ControllerConfiguration<R> configFor(Reconciler<R> reconciler) {
        return new AnnotationControllerConfiguration<R>(reconciler);
    }

    static {
        ConfigurationServiceProvider.setDefault((ConfigurationService)instance);
    }
}

