/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.query.Query;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataPublisherUtils;
import io.objectbox.reactive.DataSubscription;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;

@Internal
class QueryPublisher<T>
implements DataPublisher<List<T>>,
Runnable {
    private final Query<T> query;
    private final Box<T> box;
    private final Set<DataObserver<List<T>>> observers = new CopyOnWriteArraySet<DataObserver<List<T>>>();
    private final Deque<DataObserver<List<T>>> publishQueue = new ArrayDeque<DataObserver<List<T>>>();
    private volatile boolean publisherRunning = false;
    private final SubscribedObservers<T> SUBSCRIBED_OBSERVERS = new SubscribedObservers();
    private DataObserver<Class<T>> objectClassObserver;
    private DataSubscription objectClassSubscription;

    QueryPublisher(Query<T> query, Box<T> box) {
        this.query = query;
        this.box = box;
    }

    @Override
    public synchronized void subscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        BoxStore store = this.box.getStore();
        if (this.objectClassObserver == null) {
            this.objectClassObserver = objectClass -> this.publish();
        }
        if (this.observers.isEmpty()) {
            if (this.objectClassSubscription != null) {
                throw new IllegalStateException("Existing subscription found");
            }
            this.objectClassSubscription = store.subscribe(this.box.getEntityClass()).weak().onlyChanges().observer(this.objectClassObserver);
        }
        this.observers.add(observer);
    }

    @Override
    public void publishSingle(DataObserver<List<T>> observer, @Nullable Object param) {
        this.queueObserverAndScheduleRun(observer);
    }

    void publish() {
        this.queueObserverAndScheduleRun(this.SUBSCRIBED_OBSERVERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueObserverAndScheduleRun(DataObserver<List<T>> observer) {
        Deque<DataObserver<List<T>>> deque = this.publishQueue;
        synchronized (deque) {
            this.publishQueue.add(observer);
            if (!this.publisherRunning) {
                this.publisherRunning = true;
                this.box.getStore().internalScheduleThread(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            block6: while (true) {
                singlePublishObservers = new ArrayList<DataObserver<List<T>>>();
                notifySubscribedObservers = false;
                var3_3 = this.publishQueue;
                synchronized (var3_3) {
                    while ((nextObserver = this.publishQueue.poll()) != null) {
                        if (this.SUBSCRIBED_OBSERVERS.equals(nextObserver)) {
                            notifySubscribedObservers = true;
                            continue;
                        }
                        singlePublishObservers.add((DataObserver<List<T>>)nextObserver);
                    }
                    if (!notifySubscribedObservers && singlePublishObservers.isEmpty()) {
                        this.publisherRunning = false;
                        break;
                    }
                }
                result = this.query.find();
                nextObserver = singlePublishObservers.iterator();
                while (nextObserver.hasNext()) {
                    observer = (DataObserver)nextObserver.next();
                    observer.onData(result);
                }
                if (!notifySubscribedObservers) continue;
                observers = this.observers;
                var5_5 = observers.iterator();
                while (true) {
                    if (var5_5.hasNext()) ** break;
                    continue block6;
                    dataObserver = var5_5.next();
                    dataObserver.onData(result);
                }
                break;
            }
        }
        finally {
            this.publisherRunning = false;
        }
    }

    @Override
    public synchronized void unsubscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        DataPublisherUtils.removeObserverFromCopyOnWriteSet(this.observers, observer);
        if (this.observers.isEmpty()) {
            this.objectClassSubscription.cancel();
            this.objectClassSubscription = null;
        }
    }

    private static class SubscribedObservers<T>
    implements DataObserver<List<T>> {
        private SubscribedObservers() {
        }

        @Override
        public void onData(List<T> data) {
        }
    }
}

