/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.query.Query;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataPublisherUtils;
import io.objectbox.reactive.DataSubscription;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;

@Internal
class QueryPublisher<T>
implements DataPublisher<List<T>>,
Runnable {
    public static boolean LOG_STATES = false;
    private final Query<T> query;
    private final Box<T> box;
    private final Set<DataObserver<List<T>>> observers = new CopyOnWriteArraySet<DataObserver<List<T>>>();
    private final Deque<DataObserver<List<T>>> publishQueue = new ArrayDeque<DataObserver<List<T>>>();
    private volatile boolean publisherRunning = false;
    private volatile boolean publisherStopped = false;
    private final SubscribedObservers<T> SUBSCRIBED_OBSERVERS = new SubscribedObservers();
    private DataObserver<Class<T>> objectClassObserver;
    private DataSubscription objectClassSubscription;

    QueryPublisher(Query<T> query, Box<T> box) {
        this.query = query;
        this.box = box;
    }

    @Override
    public synchronized void subscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        BoxStore store = this.box.getStore();
        if (this.objectClassObserver == null) {
            this.objectClassObserver = objectClass -> this.publish();
        }
        if (this.observers.isEmpty()) {
            if (this.objectClassSubscription != null) {
                throw new IllegalStateException("Existing subscription found");
            }
            this.objectClassSubscription = store.subscribe(this.box.getEntityClass()).weak().onlyChanges().observer(this.objectClassObserver);
        }
        this.observers.add(observer);
    }

    @Override
    public void publishSingle(DataObserver<List<T>> observer, @Nullable Object param) {
        this.queueObserverAndScheduleRun(observer);
    }

    void publish() {
        this.queueObserverAndScheduleRun(this.SUBSCRIBED_OBSERVERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueObserverAndScheduleRun(DataObserver<List<T>> observer) {
        Deque<DataObserver<List<T>>> deque = this.publishQueue;
        synchronized (deque) {
            if (this.publisherStopped) {
                return;
            }
            this.publishQueue.add(observer);
            if (!this.publisherRunning) {
                this.publisherRunning = true;
                this.box.getStore().internalScheduleThread(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopAndAwait() {
        this.publisherStopped = true;
        QueryPublisher queryPublisher = this;
        synchronized (queryPublisher) {
            while (this.publisherRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (!this.publisherRunning) continue;
                    throw new RuntimeException("Interrupted while waiting for publisher to finish", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        QueryPublisher.log("started");
        try {
            while (!this.publisherStopped) {
                Object nextObserver;
                QueryPublisher.log("checking for observers");
                ArrayList<DataObserver<List<T>>> singlePublishObservers = new ArrayList<DataObserver<List<T>>>();
                boolean notifySubscribedObservers = false;
                Deque<DataObserver<List<T>>> deque = this.publishQueue;
                synchronized (deque) {
                    while ((nextObserver = this.publishQueue.poll()) != null) {
                        if (this.SUBSCRIBED_OBSERVERS.equals(nextObserver)) {
                            notifySubscribedObservers = true;
                            continue;
                        }
                        singlePublishObservers.add((DataObserver<List<T>>)nextObserver);
                    }
                    if (!notifySubscribedObservers && singlePublishObservers.isEmpty()) {
                        this.publisherRunning = false;
                        break;
                    }
                }
                QueryPublisher.log("running query");
                if (this.publisherStopped) {
                    break;
                }
                List<T> result = this.query.find();
                QueryPublisher.log("notifying observers");
                nextObserver = singlePublishObservers.iterator();
                while (nextObserver.hasNext()) {
                    DataObserver observer = (DataObserver)nextObserver.next();
                    observer.onData(result);
                }
                if (!notifySubscribedObservers) continue;
                Set<DataObserver<List<T>>> observers = this.observers;
                for (DataObserver<List<List<T>>> dataObserver : observers) {
                    dataObserver.onData(result);
                }
            }
        }
        finally {
            QueryPublisher.log("stopped");
            this.publisherRunning = false;
            QueryPublisher queryPublisher = this;
            synchronized (queryPublisher) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void unsubscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        DataPublisherUtils.removeObserverFromCopyOnWriteSet(this.observers, observer);
        if (this.observers.isEmpty()) {
            this.objectClassSubscription.cancel();
            this.objectClassSubscription = null;
        }
    }

    private static void log(String message) {
        if (LOG_STATES) {
            System.out.println("QueryPublisher: " + message);
        }
    }

    private static class SubscribedObservers<T>
    implements DataObserver<List<T>> {
        private SubscribedObservers() {
        }

        @Override
        public void onData(List<T> data) {
        }
    }
}

