/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.exception.FeatureNotAvailableException;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.SyncClientImpl;
import io.objectbox.sync.SyncCredentials;
import io.objectbox.sync.internal.Platform;
import io.objectbox.sync.listener.SyncChangeListener;
import io.objectbox.sync.listener.SyncCompletedListener;
import io.objectbox.sync.listener.SyncConnectionListener;
import io.objectbox.sync.listener.SyncListener;
import io.objectbox.sync.listener.SyncLoginListener;
import io.objectbox.sync.listener.SyncTimeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public final class SyncBuilder {
    final Platform platform;
    final BoxStore boxStore;
    final List<String> urls = new ArrayList<String>();
    final List<SyncCredentials> credentials = new ArrayList<SyncCredentials>();
    @Nullable
    SyncLoginListener loginListener;
    @Nullable
    SyncCompletedListener completedListener;
    @Nullable
    SyncChangeListener changeListener;
    @Nullable
    SyncConnectionListener connectionListener;
    @Nullable
    SyncTimeListener timeListener;
    @Nullable
    SyncListener listener;
    @Nullable
    String[] trustedCertPaths;
    int flags;
    boolean uncommittedAcks;
    RequestUpdatesMode requestUpdatesMode = RequestUpdatesMode.AUTO;
    final Map<String, String> filterVariables = new TreeMap<String, String>();

    private static void checkSyncFeatureAvailable() {
        if (!BoxStore.isSyncAvailable()) {
            throw new FeatureNotAvailableException("This library does not include ObjectBox Sync. Please visit https://objectbox.io/sync/ for options.");
        }
    }

    SyncBuilder(BoxStore boxStore) {
        this.checkNotNull(boxStore, "boxStore");
        this.boxStore = boxStore;
        SyncBuilder.checkSyncFeatureAvailable();
        this.platform = Platform.findPlatform();
    }

    public SyncBuilder url(String url) {
        this.checkNotNull(url, "url");
        this.urls.add(url);
        return this;
    }

    public SyncBuilder urls(List<String> urls) {
        this.checkNotNull(urls, "urls");
        for (String url : urls) {
            this.url(url);
        }
        return this;
    }

    public SyncBuilder credentials(SyncCredentials credentials) {
        this.checkNotNull(credentials, "credentials");
        this.credentials.add(credentials);
        return this;
    }

    public SyncBuilder credentials(List<SyncCredentials> credentials) {
        this.checkNotNull(credentials, "credentials");
        for (SyncCredentials credential : credentials) {
            this.credentials(credential);
        }
        return this;
    }

    public SyncBuilder filterVariable(String name, String value) {
        this.checkNotNull(name, "name");
        this.checkNotNull(value, "value");
        this.filterVariables.put(name, value);
        return this;
    }

    public SyncBuilder trustedCertificates(String[] paths) {
        this.trustedCertPaths = Arrays.copyOf(paths, paths.length);
        return this;
    }

    public SyncBuilder flags(int flags) {
        this.flags = flags;
        return this;
    }

    public SyncBuilder requestUpdatesMode(RequestUpdatesMode requestUpdatesMode) {
        this.requestUpdatesMode = requestUpdatesMode;
        return this;
    }

    public SyncBuilder uncommittedAcks() {
        this.uncommittedAcks = true;
        return this;
    }

    public SyncBuilder loginListener(SyncLoginListener loginListener) {
        this.loginListener = loginListener;
        return this;
    }

    public SyncBuilder completedListener(SyncCompletedListener completedListener) {
        this.completedListener = completedListener;
        return this;
    }

    public SyncBuilder changeListener(SyncChangeListener changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SyncBuilder timeListener(SyncTimeListener timeListener) {
        this.timeListener = timeListener;
        return this;
    }

    public SyncBuilder connectionListener(SyncConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    public SyncBuilder listener(SyncListener listener) {
        this.listener = listener;
        return this;
    }

    public SyncClient build() {
        if (this.boxStore.getSyncClient() != null) {
            throw new IllegalStateException("The given store is already associated with a Sync client, close it first.");
        }
        return new SyncClientImpl(this);
    }

    public SyncClient buildAndStart() {
        SyncClient syncClient = this.build();
        syncClient.start();
        return syncClient;
    }

    private void checkNotNull(@Nullable Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " must not be null.");
        }
    }

    public static enum RequestUpdatesMode {
        MANUAL,
        AUTO,
        AUTO_NO_PUSHES;

    }
}

