/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.sync;

import io.objectbox.BoxStore;
import io.objectbox.sync.SyncClient;
import io.objectbox.sync.server.SyncServer;
import java.io.Closeable;

public final class SyncHybrid
implements Closeable {
    private BoxStore store;
    private final SyncClient client;
    private BoxStore storeServer;
    private final SyncServer server;

    SyncHybrid(BoxStore store, SyncClient client, BoxStore storeServer, SyncServer server) {
        this.store = store;
        this.client = client;
        this.storeServer = storeServer;
        this.server = server;
    }

    public BoxStore getStore() {
        return this.store;
    }

    public SyncClient getClient() {
        return this.client;
    }

    public SyncServer getServer() {
        return this.server;
    }

    public void stop() {
        this.client.stop();
        this.server.stop();
    }

    @Override
    public void close() {
        this.store = null;
        this.client.close();
        this.server.close();
        if (this.storeServer != null) {
            this.storeServer.close();
            this.storeServer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

