/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client;

import io.orangebeard.client.OrangebeardProperty;
import io.orangebeard.client.entity.Attribute;
import io.orangebeard.client.entity.log.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrangebeardProperties {
    private static final String ORANGEBEARD_PROPERTY_FILE = "orangebeard.properties";
    private static final String ORANGEBEARD_JSON_FILE = "orangebeard.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(OrangebeardProperties.class);
    private String endpoint;
    private UUID accessToken;
    private String projectName;
    private String testSetName;
    private String description;
    private Set<Attribute> attributes = new HashSet<Attribute>();
    private boolean propertyFilePresent;
    private LogLevel logLevel = LogLevel.INFO;
    private boolean logsAtEndOfTest = false;
    private UUID testRunUUID;

    public OrangebeardProperties(String endpoint, UUID accessToken, String projectName, String testSetName, String description, Set<Attribute> attributes, LogLevel logLevel, boolean logsAtEndOfTest, UUID testRunUUID) {
        this(endpoint, accessToken, projectName, testSetName, description, attributes, logLevel, logsAtEndOfTest);
        this.testRunUUID = testRunUUID;
    }

    public OrangebeardProperties(String endpoint, UUID accessToken, String projectName, String testSetName, String description, Set<Attribute> attributes, LogLevel logLevel, boolean logsAtEndOfTest) {
        this.endpoint = endpoint;
        this.accessToken = accessToken;
        this.projectName = projectName;
        this.testSetName = testSetName;
        this.description = description;
        this.attributes = attributes;
        this.propertyFilePresent = false;
        this.logLevel = logLevel;
        this.logsAtEndOfTest = logsAtEndOfTest;
    }

    public OrangebeardProperties(String endpoint, UUID accessToken, String projectName, String testSetName) {
        this.endpoint = endpoint;
        this.accessToken = accessToken;
        this.projectName = projectName;
        this.testSetName = testSetName;
        this.propertyFilePresent = false;
    }

    OrangebeardProperties(String propertyFile, String jsonFileName) {
        this.readPropertyFile(propertyFile);
        this.readPropertyJsonFile(jsonFileName);
        this.readSystemProperties();
        this.readEnvironmentVariables(PropertyNameStyle.DOT);
        this.readEnvironmentVariables(PropertyNameStyle.UNDERSCORE);
    }

    OrangebeardProperties(String propertyFile) {
        this.readPropertyFile(propertyFile);
        this.readPropertyJsonFile(ORANGEBEARD_JSON_FILE);
        this.readSystemProperties();
        this.readEnvironmentVariables(PropertyNameStyle.DOT);
        this.readEnvironmentVariables(PropertyNameStyle.UNDERSCORE);
    }

    public OrangebeardProperties() {
        this(ORANGEBEARD_PROPERTY_FILE, ORANGEBEARD_JSON_FILE);
    }

    public boolean requiredValuesArePresent() {
        return this.endpoint != null && this.accessToken != null && this.projectName != null && this.testSetName != null;
    }

    public boolean isAnnouncedUUIDPresent() {
        return this.testRunUUID != null;
    }

    public void checkPropertiesArePresent() {
        if (!this.requiredValuesArePresent()) {
            LOGGER.error("Required Orangebeard properties are missing. Not all environment variables are present, and/or orangebeard.properties misses required values!\n{}", (Object)this.requiredPropertiesToString());
        }
    }

    private String requiredPropertiesToString() {
        return OrangebeardProperty.ENDPOINT.getPropertyName() + ": " + this.endpoint + "\n" + OrangebeardProperty.ACCESS_TOKEN.getPropertyName() + ": " + (this.accessToken != null ? "HIDDEN (PRESENT)" : "null\n") + OrangebeardProperty.PROJECT.getPropertyName() + ": " + this.projectName + "\n" + OrangebeardProperty.TESTSET.getPropertyName() + ": " + this.testSetName + "\n";
    }

    private void readPropertyFile(String name) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);
            if (inputStream != null) {
                properties.load(inputStream);
                this.propertyFilePresent = true;
            }
            this.readPropertiesWith(properties::getProperty);
        }
        catch (IOException e) {
            this.propertyFilePresent = false;
        }
    }

    private void readPropertyJsonFile(String jsonFileName) {
        JSONObject jsonConfig = OrangebeardProperties.getJsonConfig(jsonFileName);
        if (jsonConfig != null) {
            this.readPropertiesWith(key -> this.getJsonConfigValue((String)key, jsonConfig));
        }
    }

    private void readSystemProperties() {
        this.readPropertiesWith(System::getProperty);
    }

    private void readEnvironmentVariables(PropertyNameStyle style) {
        if (style == PropertyNameStyle.UNDERSCORE) {
            this.readPropertiesWith(n -> System.getenv(n.replace(".", "_")));
        } else {
            this.readPropertiesWith(System::getenv);
        }
    }

    private static JSONObject getJsonConfig(String jsonFileName) {
        for (Path currentDir = Paths.get("", new String[0]).toAbsolutePath(); currentDir != null; currentDir = currentDir.getParent()) {
            Path filePath = currentDir.resolve(jsonFileName);
            if (!Files.exists(filePath, new LinkOption[0])) continue;
            try {
                String content = Files.readString(filePath, StandardCharsets.UTF_8);
                return new JSONObject(content);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private String getJsonConfigValue(String key, JSONObject jsonConfiguration) {
        try {
            return jsonConfiguration.get(key.replace("orangebeard.", "")).toString();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private void readPropertiesWith(UnaryOperator<String> lookupFunc) {
        this.endpoint = this.lookupWithDefault(OrangebeardProperty.ENDPOINT, lookupFunc, this.endpoint);
        this.accessToken = this.lookupUUIDWithDefault(OrangebeardProperty.TOKEN, lookupFunc, this.accessToken);
        if (this.accessToken == null) {
            this.accessToken = this.lookupUUIDWithDefault(OrangebeardProperty.ACCESS_TOKEN, lookupFunc, null);
        }
        this.projectName = this.lookupWithDefault(OrangebeardProperty.PROJECT, lookupFunc, this.projectName);
        this.testSetName = this.lookupWithDefault(OrangebeardProperty.TESTSET, lookupFunc, this.testSetName);
        this.description = this.lookupWithDefault(OrangebeardProperty.DESCRIPTION, lookupFunc, this.description);
        this.logLevel = this.lookupLogLevel(lookupFunc);
        this.logsAtEndOfTest = this.lookUpBooleanWithDefault(OrangebeardProperty.LOGS_AT_END_OF_TEST, lookupFunc, this.logsAtEndOfTest);
        this.attributes.addAll(this.extractAttributes((String)lookupFunc.apply(OrangebeardProperty.ATTRIBUTES.getPropertyName())));
        this.testRunUUID = this.lookupUUIDWithDefault(OrangebeardProperty.TEST_RUN_UUID, lookupFunc, this.testRunUUID);
        if (this.lookupWithDefault(OrangebeardProperty.REFERENCE_URL, lookupFunc, null) != null) {
            this.attributes.add(new Attribute("reference_url", this.lookupWithDefault(OrangebeardProperty.REFERENCE_URL, lookupFunc, null)));
        }
    }

    private boolean lookUpBooleanWithDefault(OrangebeardProperty property, UnaryOperator<String> lookupFunc, boolean defaultValue) {
        String temp = (String)lookupFunc.apply(property.getPropertyName());
        if (temp == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(temp);
    }

    private String lookupWithDefault(OrangebeardProperty property, UnaryOperator<String> lookupFunc, String defaultValue) {
        String temp = (String)lookupFunc.apply(property.getPropertyName());
        return temp == null ? defaultValue : temp;
    }

    private UUID lookupUUIDWithDefault(OrangebeardProperty property, UnaryOperator<String> lookupFunc, UUID defaultValue) {
        String temp = (String)lookupFunc.apply(property.getPropertyName());
        if (temp == null || temp.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return UUID.fromString(temp);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(OrangebeardProperty.ACCESS_TOKEN.getPropertyName(), (Object)"{0} is not a valid UUID!");
            return defaultValue;
        }
    }

    private LogLevel lookupLogLevel(UnaryOperator<String> lookupFunc) {
        String logLevelProperty = (String)lookupFunc.apply(OrangebeardProperty.LOG_LEVEL.getPropertyName());
        try {
            return logLevelProperty == null ? this.logLevel : LogLevel.valueOf(logLevelProperty);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn(String.format("%s is not a valid log level! Choose DEBUG, INFO, WARN or ERROR. INFO is now used by default.", OrangebeardProperty.LOG_LEVEL.getPropertyName()));
            return this.logLevel;
        }
    }

    private Set<Attribute> extractAttributes(String attributeString) {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        if (attributeString == null || attributeString.isEmpty()) {
            return attrs;
        }
        if (attributeString.startsWith("[")) {
            JSONArray jsonAttrs = new JSONArray(attributeString);
            for (Object attribute : jsonAttrs) {
                JSONObject attr = (JSONObject)attribute;
                attrs.add(attr.has("key") ? new Attribute(attr.getString("key"), attr.getString("value")) : new Attribute(attr.getString("value")));
            }
        } else {
            for (String attribute : attributeString.split(";")) {
                if (attribute.contains(":")) {
                    String[] keyValuePair = attribute.trim().split(":", 2);
                    attrs.add(new Attribute(keyValuePair[0].trim(), keyValuePair[1].trim()));
                    continue;
                }
                attrs.add(new Attribute(attribute.trim()));
            }
        }
        return attrs;
    }

    public boolean logShouldBeDispatchedToOrangebeard(LogLevel individualLogLevel) {
        int logLevelVal = this.convertToInt(this.logLevel);
        int individualLogLevelVal = this.convertToInt(individualLogLevel);
        return individualLogLevelVal >= logLevelVal;
    }

    private int convertToInt(LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                return 0;
            }
            case INFO: {
                return 1;
            }
            case WARN: {
                return 2;
            }
        }
        return 1;
    }

    @Generated
    public String toString() {
        return "OrangebeardProperties(endpoint=" + this.getEndpoint() + ", accessToken=" + this.getAccessToken() + ", projectName=" + this.getProjectName() + ", testSetName=" + this.getTestSetName() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", propertyFilePresent=" + this.isPropertyFilePresent() + ", logLevel=" + this.getLogLevel() + ", logsAtEndOfTest=" + this.isLogsAtEndOfTest() + ", testRunUUID=" + this.getTestRunUUID() + ")";
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public UUID getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getTestSetName() {
        return this.testSetName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean isPropertyFilePresent() {
        return this.propertyFilePresent;
    }

    @Generated
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public boolean isLogsAtEndOfTest() {
        return this.logsAtEndOfTest;
    }

    @Generated
    public UUID getTestRunUUID() {
        return this.testRunUUID;
    }

    private static enum PropertyNameStyle {
        DOT,
        UNDERSCORE;

    }
}

