/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client;

import io.orangebeard.client.entity.FinishV3TestRun;
import io.orangebeard.client.entity.Response;
import io.orangebeard.client.entity.StartV3TestRun;
import io.orangebeard.client.entity.attachment.Attachment;
import io.orangebeard.client.entity.log.Log;
import io.orangebeard.client.entity.step.FinishStep;
import io.orangebeard.client.entity.step.StartStep;
import io.orangebeard.client.entity.suite.StartSuite;
import io.orangebeard.client.entity.suite.Suite;
import io.orangebeard.client.entity.test.FinishTest;
import io.orangebeard.client.entity.test.StartTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@EnableRetry
public class OrangebeardV3Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrangebeardV3Client.class);
    private static final String CONNECTION_FAILED = "The connection with Orangebeard could not be established!";
    private final String endpoint;
    private final RestTemplate restTemplate;
    private final String projectName;
    private boolean connectionWithOrangebeardIsValid;
    protected final UUID accessToken;

    protected HttpHeaders getAuthorizationHeaders(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    public OrangebeardV3Client(String endpoint, UUID accessToken, String projectName, boolean connectionWithOrangebeardIsValid) {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(30000);
        this.accessToken = accessToken;
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        this.projectName = projectName;
        this.endpoint = endpoint;
        this.connectionWithOrangebeardIsValid = connectionWithOrangebeardIsValid;
    }

    public OrangebeardV3Client(RestTemplate restTemplate, String endpoint, UUID uuid, String projectName, boolean connectionWithOrangebeardIsValid) {
        this.accessToken = uuid;
        this.restTemplate = restTemplate;
        this.projectName = projectName;
        this.endpoint = endpoint;
        this.connectionWithOrangebeardIsValid = connectionWithOrangebeardIsValid;
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public UUID startTestRun(StartV3TestRun testRun) {
        if (this.connectionWithOrangebeardIsValid) {
            try {
                HttpEntity request = new HttpEntity((Object)testRun, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
                ResponseEntity response = this.restTemplate.exchange(String.format("%s/listener/v3/%s/test-run/start", this.endpoint, this.projectName), HttpMethod.POST, request, UUID.class, new Object[0]);
                return response.getBody() != null ? (UUID)response.getBody() : null;
            }
            catch (Exception var3) {
                LOGGER.error("The connection with Orangebeard could not be established! Check the properties and try again!");
                this.connectionWithOrangebeardIsValid = false;
            }
        }
        return null;
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public void startAnnouncedTestRun(UUID testRunUUID) {
        if (this.connectionWithOrangebeardIsValid) {
            try {
                HttpEntity request = new HttpEntity((MultiValueMap)this.getAuthorizationHeaders(this.accessToken.toString()));
                this.restTemplate.exchange(String.format("%s/listener/v3/%s/test-run/start/%s", this.endpoint, this.projectName, testRunUUID), HttpMethod.PUT, request, Response.class, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("The connection with Orangebeard could not be established!Check the properties and try again!");
                this.connectionWithOrangebeardIsValid = false;
            }
        }
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public void finishTestRun(UUID testRunUUID, FinishV3TestRun finishTestRun) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)finishTestRun, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            this.restTemplate.exchange(String.format("%s/listener/v3/%s/test-run/finish/%s", this.endpoint, this.projectName, testRunUUID), HttpMethod.PUT, request, Void.class, new Object[0]);
        } else {
            LOGGER.warn(CONNECTION_FAILED);
        }
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public List<Suite> startSuite(StartSuite startSuite) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)startSuite, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            ResponseEntity response = this.restTemplate.exchange(String.format("%s/listener/v3/%s/suite/start", this.endpoint, this.projectName), HttpMethod.POST, request, Suite[].class, new Object[0]);
            return Arrays.asList(Objects.requireNonNull((Suite[])response.getBody()));
        }
        LOGGER.warn(CONNECTION_FAILED);
        return Collections.emptyList();
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public UUID startTest(StartTest startTest) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)startTest, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            ResponseEntity response = this.restTemplate.exchange(String.format("%s/listener/v3/%s/test/start", this.endpoint, this.projectName), HttpMethod.POST, request, UUID.class, new Object[0]);
            return response.getBody() != null ? (UUID)response.getBody() : null;
        }
        LOGGER.warn(CONNECTION_FAILED);
        return null;
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public void finishTest(UUID testUUID, FinishTest finishTest) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)finishTest, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            String url = String.format("%s/listener/v3/%s/test/finish/%s", this.endpoint, this.projectName, testUUID);
            this.restTemplate.exchange(url, HttpMethod.PUT, request, Void.class, new Object[0]);
        } else {
            LOGGER.warn(CONNECTION_FAILED);
        }
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public UUID startStep(StartStep startStep) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)startStep, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            return (UUID)this.restTemplate.exchange(String.format("%s/listener/v3/%s/step/start", this.endpoint, this.projectName), HttpMethod.POST, request, UUID.class, new Object[0]).getBody();
        }
        LOGGER.warn(CONNECTION_FAILED);
        return null;
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public void finishStep(UUID stepUUID, FinishStep finishStep) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)finishStep, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            this.restTemplate.exchange(String.format("%s/listener/v3/%s/step/finish/%s", this.endpoint, this.projectName, stepUUID), HttpMethod.PUT, request, Void.class, new Object[0]);
        } else {
            LOGGER.warn(CONNECTION_FAILED);
        }
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public UUID log(Log log) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity((Object)log, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            return (UUID)this.restTemplate.exchange(String.format("%s/listener/v3/%s/log", this.endpoint, this.projectName), HttpMethod.POST, request, UUID.class, new Object[0]).getBody();
        }
        LOGGER.warn(CONNECTION_FAILED);
        return null;
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public void sendLogBatch(List<Log> logs) {
        if (this.connectionWithOrangebeardIsValid) {
            HttpEntity request = new HttpEntity(logs, (MultiValueMap)this.getAuthorizationHeaders(String.valueOf(this.accessToken)));
            this.restTemplate.exchange(String.format("%s/listener/v3/%s/log/batch", this.endpoint, this.projectName), HttpMethod.POST, request, Void.class, new Object[0]);
        } else {
            LOGGER.warn(CONNECTION_FAILED);
        }
    }

    @Retryable(value={Exception.class}, maxAttempts=4, backoff=@Backoff(delay=2000L, multiplier=2.0))
    public UUID sendAttachment(Attachment attachment) {
        if (this.connectionWithOrangebeardIsValid) {
            LinkedMultiValueMap filePartHeaders = new LinkedMultiValueMap();
            filePartHeaders.add((Object)"Content-Disposition", (Object)String.format("form-data; name=\"attachment\"; filename=\"%s\"", attachment.getFile().getName()));
            filePartHeaders.add((Object)"Content-Type", (Object)attachment.getFile().getContentType());
            byte[] fileContents = attachment.getFile().getContent();
            HttpEntity filePart = new HttpEntity((Object)fileContents, (MultiValueMap)filePartHeaders);
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            parts.add((Object)"json", (Object)attachment.getMetaData());
            parts.add((Object)"attachment", (Object)filePart);
            HttpHeaders headers = this.getAuthorizationHeaders(String.valueOf(this.accessToken));
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity request = new HttpEntity((Object)parts, (MultiValueMap)headers);
            return (UUID)this.restTemplate.exchange(String.format("%s/listener/v3/%s/attachment", this.endpoint, this.projectName), HttpMethod.POST, request, UUID.class, new Object[0]).getBody();
        }
        LOGGER.warn(CONNECTION_FAILED);
        return null;
    }
}

