/*
 * Decompiled with CFR 0.152.
 */
package io.orangebeard.client.v3;

import io.orangebeard.client.OrangebeardProperties;
import io.orangebeard.client.OrangebeardV3Client;
import io.orangebeard.client.entity.FinishV3TestRun;
import io.orangebeard.client.entity.StartV3TestRun;
import io.orangebeard.client.entity.attachment.Attachment;
import io.orangebeard.client.entity.log.Log;
import io.orangebeard.client.entity.step.FinishStep;
import io.orangebeard.client.entity.step.StartStep;
import io.orangebeard.client.entity.suite.StartSuite;
import io.orangebeard.client.entity.suite.Suite;
import io.orangebeard.client.entity.test.FinishTest;
import io.orangebeard.client.entity.test.StartTest;
import io.orangebeard.client.v3.V3Client;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OrangebeardAsyncV3Client
implements V3Client {
    private final ConcurrentHashMap<UUID, CompletableFuture<Object>> tasks;
    private final ConcurrentHashMap<UUID, UUID> uuidMap;
    private final OrangebeardV3Client client;

    public OrangebeardAsyncV3Client(String endpoint, UUID accessToken, String projectName, boolean connectionWithOrangebeardIsValid) {
        this.client = new OrangebeardV3Client(endpoint, accessToken, projectName, connectionWithOrangebeardIsValid);
        this.tasks = new ConcurrentHashMap();
        this.uuidMap = new ConcurrentHashMap();
    }

    public OrangebeardAsyncV3Client(OrangebeardProperties configuration) {
        this.client = new OrangebeardV3Client(configuration.getEndpoint(), configuration.getAccessToken(), configuration.getProjectName(), configuration.requiredValuesArePresent());
        this.tasks = new ConcurrentHashMap();
        this.uuidMap = new ConcurrentHashMap();
    }

    public OrangebeardAsyncV3Client() {
        this(new OrangebeardProperties());
    }

    private CompletableFuture<Object> parentTask(UUID taskUUID) {
        return this.tasks.get(taskUUID);
    }

    @Override
    public UUID startTestRun(StartV3TestRun testRun) {
        UUID temporaryUUID = UUID.randomUUID();
        CompletableFuture startTestRunTask = new CompletableFuture();
        this.tasks.put(temporaryUUID, startTestRunTask);
        CompletableFuture.runAsync(() -> {
            UUID actualUUID = this.client.startTestRun(testRun);
            this.uuidMap.put(temporaryUUID, actualUUID);
            startTestRunTask.complete(actualUUID);
        });
        return temporaryUUID;
    }

    @Override
    public void startAnnouncedTestRun(UUID testRunUUID) {
        CompletableFuture startTestRunTask = new CompletableFuture();
        this.tasks.put(testRunUUID, startTestRunTask);
        CompletableFuture.runAsync(() -> {
            this.client.startAnnouncedTestRun(testRunUUID);
            startTestRunTask.complete(testRunUUID);
        });
        this.uuidMap.put(testRunUUID, testRunUUID);
    }

    @Override
    public void finishTestRun(UUID testRunUUID, FinishV3TestRun finishTestRun) {
        CompletableFuture<Void> allTasks = CompletableFuture.allOf(this.tasks.values().toArray(new CompletableFuture[0]));
        allTasks.join();
        this.client.finishTestRun(this.uuidMap.get(testRunUUID), finishTestRun);
    }

    @Override
    public List<UUID> startSuite(StartSuite startSuite) {
        List tempUUIDs = startSuite.getSuiteNames().stream().map(suite -> UUID.randomUUID()).collect(Collectors.toCollection(LinkedList::new));
        CompletableFuture<Object> parent = startSuite.getParentSuiteUUID() != null ? this.parentTask(startSuite.getParentSuiteUUID()) : this.parentTask(startSuite.getTestRunUUID());
        CompletableFuture startSuiteTask = new CompletableFuture();
        tempUUIDs.forEach(tempUUID -> this.tasks.put((UUID)tempUUID, startSuiteTask));
        parent.thenCompose(parentUUID -> {
            UUID testRunUUID;
            UUID parentSuiteUUID = null;
            if (startSuite.getParentSuiteUUID() == null) {
                testRunUUID = (UUID)parentUUID;
            } else {
                testRunUUID = this.uuidMap.get(startSuite.getTestRunUUID());
                parentSuiteUUID = parentUUID instanceof List ? (UUID)((List)parentUUID).get(((List)parentUUID).size() - 1) : (UUID)parentUUID;
            }
            StartSuite realStartSuite = new StartSuite(testRunUUID, parentSuiteUUID, startSuite.getDescription(), startSuite.getAttributes(), startSuite.getSuiteNames());
            List<Suite> suites = this.client.startSuite(realStartSuite);
            List actualUUIDs = suites.stream().map(Suite::getSuiteUUID).collect(Collectors.toList());
            startSuiteTask.complete(actualUUIDs);
            return CompletableFuture.supplyAsync(() -> actualUUIDs);
        });
        return tempUUIDs;
    }

    @Override
    public UUID startTest(StartTest startTest) {
        UUID temporaryUUID = UUID.randomUUID();
        CompletableFuture<Object> parent = this.parentTask(startTest.getSuiteUUID());
        CompletableFuture startTestTask = new CompletableFuture();
        this.tasks.put(temporaryUUID, startTestTask);
        parent.thenCompose(parentUUID -> {
            UUID parentSuiteUUID = (UUID)((List)parentUUID).get(((List)parentUUID).size() - 1);
            StartTest realStartTest = new StartTest(this.uuidMap.get(startTest.getTestRunUUID()), parentSuiteUUID, startTest.getTestName(), startTest.getTestType(), startTest.getDescription(), startTest.getAttributes(), startTest.getStartTime());
            UUID actualUUID = this.client.startTest(realStartTest);
            this.uuidMap.put(temporaryUUID, actualUUID);
            startTestTask.complete(actualUUID);
            return CompletableFuture.supplyAsync(() -> actualUUID);
        });
        return temporaryUUID;
    }

    @Override
    public void finishTest(UUID testUUID, FinishTest finishTest) {
        CompletableFuture<Object> parent = this.parentTask(testUUID);
        CompletableFuture finishTestTask = new CompletableFuture();
        this.tasks.put(UUID.randomUUID(), finishTestTask);
        parent.thenCompose(parentUUID -> {
            FinishTest realFinishTest = new FinishTest(this.uuidMap.get(finishTest.getTestRunUUID()), finishTest.getStatus(), finishTest.getEndTime());
            this.client.finishTest((UUID)parentUUID, realFinishTest);
            finishTestTask.complete(null);
            return null;
        });
    }

    @Override
    public UUID startStep(StartStep startStep) {
        UUID temporaryUUID = UUID.randomUUID();
        CompletableFuture<Object> parent = startStep.getParentStepUUID() != null ? this.parentTask(startStep.getParentStepUUID()) : this.parentTask(startStep.getTestUUID());
        CompletableFuture startStepTask = new CompletableFuture();
        this.tasks.put(temporaryUUID, startStepTask);
        parent.thenCompose(parentUUID -> {
            UUID testUUID;
            UUID parentStepUUID = null;
            if (startStep.getParentStepUUID() == null) {
                testUUID = (UUID)parentUUID;
            } else {
                testUUID = this.uuidMap.get(startStep.getTestUUID());
                parentStepUUID = (UUID)parentUUID;
            }
            StartStep realStartStep = new StartStep(this.uuidMap.get(startStep.getTestRunUUID()), testUUID, parentStepUUID, startStep.getStepName(), startStep.getDescription(), startStep.getStartTime());
            UUID actualUUID = this.client.startStep(realStartStep);
            startStepTask.complete(actualUUID);
            this.uuidMap.put(temporaryUUID, actualUUID);
            return CompletableFuture.supplyAsync(() -> actualUUID);
        });
        return temporaryUUID;
    }

    @Override
    public void finishStep(UUID stepUUID, FinishStep finishStep) {
        CompletableFuture<Object> parent = this.parentTask(stepUUID);
        CompletableFuture finishStepTask = new CompletableFuture();
        this.tasks.put(UUID.randomUUID(), finishStepTask);
        parent.thenCompose(parentUUID -> {
            FinishStep realFinishStep = new FinishStep(this.uuidMap.get(finishStep.getTestRunUUID()), finishStep.getStatus(), finishStep.getEndTime());
            this.client.finishStep((UUID)parentUUID, realFinishStep);
            finishStepTask.complete(null);
            return null;
        });
    }

    @Override
    public UUID log(Log log) {
        UUID temporaryUUID = UUID.randomUUID();
        CompletableFuture<Object> parent = log.getStepUUID() != null ? this.parentTask(log.getStepUUID()) : this.parentTask(log.getTestUUID());
        CompletableFuture logTask = new CompletableFuture();
        this.tasks.put(temporaryUUID, logTask);
        parent.thenCompose(parentUUID -> {
            UUID testUUID;
            UUID stepUUID = null;
            if (log.getStepUUID() == null) {
                testUUID = (UUID)parentUUID;
            } else {
                testUUID = this.uuidMap.get(log.getTestUUID());
                stepUUID = (UUID)parentUUID;
            }
            Log realLog = new Log(this.uuidMap.get(log.getTestRunUUID()), testUUID, stepUUID, log.getMessage(), log.getLogLevel(), log.getLogTime(), log.getLogFormat());
            UUID actualUUID = this.client.log(realLog);
            logTask.complete(actualUUID);
            this.uuidMap.put(temporaryUUID, actualUUID);
            return CompletableFuture.supplyAsync(() -> actualUUID);
        });
        return temporaryUUID;
    }

    @Override
    @Deprecated(since="2.0.0")
    public void sendLogBatch(List<Log> logs) {
        logs.forEach(this::log);
    }

    @Override
    public UUID sendAttachment(Attachment attachment) {
        UUID temporaryUUID = UUID.randomUUID();
        Attachment.AttachmentMetaData meta = attachment.getMetaData();
        CompletableFuture<Object> parent = this.parentTask(meta.getLogUUID());
        CompletableFuture attachmentTask = new CompletableFuture();
        this.tasks.put(temporaryUUID, attachmentTask);
        parent.thenCompose(logUUID -> {
            Attachment realAttachment = new Attachment(attachment.getFile(), new Attachment.AttachmentMetaData(this.uuidMap.get(meta.getTestRunUUID()), this.uuidMap.get(meta.getTestUUID()), meta.getStepUUID() == null ? null : this.uuidMap.get(meta.getStepUUID()), (UUID)logUUID, meta.getAttachmentTime()));
            UUID actualUUID = this.client.sendAttachment(realAttachment);
            attachmentTask.complete(actualUUID);
            this.uuidMap.put(temporaryUUID, actualUUID);
            return CompletableFuture.supplyAsync(() -> actualUUID);
        });
        return temporaryUUID;
    }
}

