/*
 * Decompiled with CFR 0.152.
 */
package io.testable.java;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class TestableCSVReader {
    private static final String BASE_URL = System.getProperty("TESTABLE_BASE_URL");
    private static final String AGENT_KEY = System.getProperty("TESTABLE_KEY");
    private static final long EXECUTION_ID = Long.getLong("TESTABLE_EXECUTION_ID", -1L);
    private static final long CHUNK_ID = Long.getLong("TESTABLE_CHUNK_ID", -1L);
    private String name;
    private String nameForIterator;
    private List<CSVRecord> records;
    private int index = 0;

    public TestableCSVReader(String path) throws IOException {
        this.name = path;
        this.nameForIterator = this.name.replace(".", "").replace("/", "");
        InputStream fileIs = this.getClass().getClassLoader().getResourceAsStream(path);
        CSVParser parser = CSVParser.parse((InputStream)fileIs, (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader());
        this.records = parser.getRecords();
    }

    public CSVRecord get(int index) {
        return this.records.get(index);
    }

    public CSVRecord random() {
        int index = (int)Math.floor(Math.random() * (double)this.records.size());
        return this.get(index);
    }

    public CSVRecord next() throws IOException {
        return this.next(true);
    }

    public CSVRecord next(boolean wrap) throws IOException {
        return this.next(1, wrap).get(0);
    }

    public List<CSVRecord> next(int rows) throws IOException {
        return this.next(rows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CSVRecord> next(int rows, boolean wrap) throws IOException {
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>(rows);
        if (CHUNK_ID < 0L) {
            for (int i = 0; i < rows; ++i) {
                records.add(this.get(this.index));
                if (this.index == this.records.size() - 1) {
                    this.index = 0;
                    continue;
                }
                ++this.index;
            }
        } else {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                int[] indices;
                this.name.replace(".", "").replace("/", "");
                StringBuilder sb = new StringBuilder();
                sb.append(BASE_URL).append("/rows/iterators/executions.").append(EXECUTION_ID).append(".").append(this.nameForIterator).append("/by-index?wrap=").append(wrap).append("&rows=").append(rows).append("&length=").append(this.records.size()).append("&key=").append(AGENT_KEY);
                HttpGet requestIndices = new HttpGet(sb.toString());
                ResponseHandler responseHandler = response -> {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                };
                String body = (String)httpClient.execute((HttpUriRequest)requestIndices, responseHandler);
                ObjectMapper mapper = new ObjectMapper();
                for (int nextIndex : indices = (int[])mapper.readValue(body, int[].class)) {
                    records.add(this.get(nextIndex));
                }
            }
        }
        return records;
    }
}

