/*
 * Decompiled with CFR 0.152.
 */
package io.testable.java;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import io.testable.java.TestableCSVReader;
import io.testable.java.TestableLog;
import io.testable.java.TestableMetric;
import io.testable.java.TestableTest;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Testable {
    public static final String OUTPUT_DIR = System.getProperty("OUTPUT_DIR");
    public static final String REGION_NAME = System.getProperty("TESTABLE_REGION_NAME");
    public static final String GLOBAL_CLIENT_INDEX = System.getProperty("TESTABLE_GLOBAL_CLIENT_INDEX");
    public static final String ITERATION = System.getProperty("TESTABLE_ITERATION");
    public static final String PROXY_AUTOCONFIG_URL = System.getProperty("PROXY_AUTOCONFIG_URL");
    public static final String RESULT_FILE = System.getProperty("TESTABLE_RESULT_FILE");
    private static PrintWriter resultStream;

    public static void reportMetric(TestableMetric metric) {
        Testable.writeToStream(new Result(metric.getType().name(), metric));
    }

    public static void log(TestableLog.Level level, String msg) {
        Testable.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static void log(TestableLog.Level level, Throwable cause) {
        String msg = Throwables.getStackTraceAsString((Throwable)cause);
        Testable.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static TestableCSVReader readCsv(String path) throws IOException {
        return new TestableCSVReader(path);
    }

    public static TestableTest startTest(String name) {
        return new TestableTest(name);
    }

    private static String toName(String name) {
        if (REGION_NAME != null) {
            return REGION_NAME + "-" + GLOBAL_CLIENT_INDEX + "-" + ITERATION + "-" + name;
        }
        return name;
    }

    static void writeToStream(Result result) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String text = mapper.writeValueAsString((Object)result);
            if (resultStream != null) {
                resultStream.println(text);
                resultStream.flush();
            } else {
                System.out.println("[" + result.getType() + "] " + text);
            }
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    static {
        try {
            resultStream = RESULT_FILE != null ? new PrintWriter(new FileWriter(RESULT_FILE, true)) : null;
        }
        catch (IOException ioe) {
            System.out.println("Issue writing to Testable result file");
            ioe.printStackTrace();
            resultStream = null;
        }
    }

    static class Result {
        private String type;
        private Object data;

        public Result(String type, Object data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }
}

