/*
 * Decompiled with CFR 0.152.
 */
package io.testable.selenium;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import io.testable.selenium.TestableCSVReader;
import io.testable.selenium.TestableLog;
import io.testable.selenium.TestableMetric;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class TestableSelenium {
    public static final int SELENIUM_PORT = Integer.getInteger("SELENIUM_PORT", -1);
    public static final String OUTPUT_DIR = System.getProperty("OUTPUT_DIR");
    public static final String REGION_NAME = System.getProperty("TESTABLE_REGION_NAME");
    public static final String REGIONAL_CLIENT_INDEX = System.getProperty("TESTABLE_REGIONAL_CLIENT_INDEX");
    public static final String ITERATION = System.getProperty("TESTABLE_ITERATION");
    public static final String PROXY_AUTOCONFIG_URL = System.getProperty("PROXY_AUTOCONFIG_URL");
    public static final String PAC_CHROME_EXTENSION_DIR = System.getProperty("PAC_CHROME_EXTENSION_DIR");
    public static final String RESULT_FILE = System.getProperty("TESTABLE_RESULT_FILE");
    private static String RUM_SPEEDINDEXJS;
    private static PrintWriter resultStream;

    public static WebDriver newWebDriver(Capabilities capabilities) {
        try {
            if (PROXY_AUTOCONFIG_URL != null && capabilities instanceof MutableCapabilities) {
                Proxy proxy = new Proxy();
                proxy.setProxyType(Proxy.ProxyType.PAC);
                proxy.setProxyAutoconfigUrl(PROXY_AUTOCONFIG_URL);
                ((MutableCapabilities)capabilities).setCapability("proxy", (Object)proxy);
                if (capabilities instanceof ChromeOptions && PAC_CHROME_EXTENSION_DIR != null) {
                    ((ChromeOptions)capabilities).addArguments(new String[]{"--load-extension=" + PAC_CHROME_EXTENSION_DIR});
                }
            }
            int port = SELENIUM_PORT > 0 ? SELENIUM_PORT : 4444;
            return new RemoteWebDriver(new URL("http://localhost:" + port + "/wd/hub"), capabilities);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static Path takeScreenshot(WebDriver driver, String name) {
        try {
            File screenshot = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            if (OUTPUT_DIR != null) {
                return Files.copy(screenshot.toPath(), Paths.get(OUTPUT_DIR, TestableSelenium.toName(name)), new CopyOption[0]);
            }
            return screenshot.toPath();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public static void reportMetric(TestableMetric metric) {
        TestableSelenium.writeToStream(new Result(metric.getType().name(), metric));
    }

    public static void log(TestableLog.Level level, String msg) {
        TestableSelenium.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static void log(TestableLog.Level level, Throwable cause) {
        String msg = Throwables.getStackTraceAsString((Throwable)cause);
        TestableSelenium.writeToStream(new Result("Log", new TestableLog(level, msg, System.currentTimeMillis())));
    }

    public static Map<String, Object> collectPerformanceMetrics(WebDriver driver) {
        if (RUM_SPEEDINDEXJS != null) {
            Map results = (Map)((JavascriptExecutor)driver).executeScript(RUM_SPEEDINDEXJS, new Object[0]);
            TestableSelenium.writeToStream(new Result("BrowserMetrics", results));
            return results;
        }
        return Collections.emptyMap();
    }

    public static TestableCSVReader readCsv(String path) throws IOException {
        return new TestableCSVReader(path);
    }

    private static String toName(String name) {
        if (REGION_NAME != null) {
            return REGION_NAME + "-" + REGIONAL_CLIENT_INDEX + "-" + ITERATION + "-" + name;
        }
        return name;
    }

    private static void writeToStream(Result result) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String text = mapper.writeValueAsString((Object)result);
            if (resultStream != null) {
                resultStream.println(text);
                resultStream.flush();
            } else {
                System.out.println("[" + result.getType() + "] " + text);
            }
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    static {
        try {
            URL url = Resources.getResource((String)"rum-speedindex.js");
            RUM_SPEEDINDEXJS = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            System.out.println("Issue reading rum-speedindex.js from file");
            e.printStackTrace();
            RUM_SPEEDINDEXJS = null;
        }
        try {
            resultStream = RESULT_FILE != null ? new PrintWriter(new FileWriter(RESULT_FILE, true)) : null;
        }
        catch (IOException ioe) {
            System.out.println("Issue writing to Testable result file");
            ioe.printStackTrace();
            resultStream = null;
        }
    }

    private static class Result {
        private String type;
        private Object data;

        public Result(String type, Object data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }
}

