/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.cb.ProcessCloseCallback;
import com.oracle.libuv.cb.ProcessExitCallback;
import com.oracle.libuv.handles.Handle;
import com.oracle.libuv.handles.LoopHandle;
import com.oracle.libuv.handles.StdioOptions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;

public class ProcessHandle
extends Handle {
    private boolean closed = false;
    private ProcessCloseCallback onClose = null;
    private ProcessExitCallback onExit = null;

    protected ProcessHandle(LoopHandle loop) {
        super(ProcessHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public void setCloseCallback(ProcessCloseCallback callback) {
        this.onClose = callback;
    }

    public void setExitCallback(ProcessExitCallback callback) {
        this.onExit = callback;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int spawn(String program, String[] args, String[] env, String dir, EnumSet<ProcessFlags> flags, StdioOptions[] stdio, int uid, int gid) {
        Objects.requireNonNull(program);
        Objects.requireNonNull(args);
        assert (args.length > 0);
        char[] cmdChars = args[0].toCharArray();
        boolean inQuote = false;
        ArrayList<String> javaArgs = new ArrayList<String>();
        int start = 0;
        int end = 0;
        block4: for (int i = 0; i < cmdChars.length; ++i) {
            switch (cmdChars[i]) {
                case '\"': {
                    if (inQuote) {
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    break;
                }
                case ' ': {
                    if (inQuote) break;
                    javaArgs.add(args[0].substring(start, end));
                    start = ++end;
                    continue block4;
                }
            }
            ++end;
        }
        javaArgs.add(args[0].substring(start, end));
        String[] arguments = new String[args.length + javaArgs.size() - 1];
        System.arraycopy(javaArgs.toArray(), 0, arguments, 0, javaArgs.size());
        System.arraycopy(args, 1, arguments, javaArgs.size(), args.length - 1);
        int[] stdioFlags = null;
        long[] streamPointers = null;
        int[] fds = null;
        if (stdio != null && stdio.length > 0) {
            stdioFlags = new int[stdio.length];
            streamPointers = new long[stdio.length];
            fds = new int[stdio.length];
            for (int i = 0; i < stdio.length; ++i) {
                stdioFlags[i] = stdio[i].type();
                streamPointers[i] = stdio[i].stream();
                fds[i] = stdio[i].fd();
            }
        } else {
            throw new IllegalArgumentException("StdioOptions cannot be null or empty");
        }
        int processFlags = ProcessFlags.NONE.value;
        if (flags.contains((Object)ProcessFlags.WINDOWS_VERBATIM_ARGUMENTS)) {
            processFlags |= ProcessFlags.WINDOWS_VERBATIM_ARGUMENTS.value;
        }
        if (flags.contains((Object)ProcessFlags.DETACHED)) {
            processFlags |= ProcessFlags.DETACHED.value;
        }
        return this._spawn(this.pointer, arguments[0], arguments, env, dir, processFlags, stdioFlags, streamPointers, fds, uid, gid);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    public int kill(int signal) {
        return this._kill(this.pointer, signal);
    }

    private void callClose() {
        if (this.onClose != null) {
            this.loop.getCallbackHandler().handleProcessCloseCallback(this.onClose);
        }
    }

    private void callExit(int status, int signal, Exception error) {
        if (this.onExit != null) {
            this.loop.getCallbackHandler().handleProcessExitCallback(this.onExit, status, signal, error);
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _spawn(long var1, String var3, String[] var4, String[] var5, String var6, int var7, int[] var8, long[] var9, int[] var10, int var11, int var12);

    private native void _close(long var1);

    private native int _kill(long var1, int var3);

    static {
        ProcessHandle._static_initialize();
    }

    public static enum ProcessFlags {
        NONE(0),
        SETUID(1),
        SETGID(2),
        WINDOWS_VERBATIM_ARGUMENTS(4),
        DETACHED(8),
        WINDOWS_HIDE(16);

        final int value;

        private ProcessFlags(int value) {
            this.value = value;
        }
    }
}

