/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.cb.StreamCloseCallback;
import com.oracle.libuv.cb.StreamConnectCallback;
import com.oracle.libuv.cb.StreamConnectionCallback;
import com.oracle.libuv.cb.StreamReadCallback;
import com.oracle.libuv.cb.StreamShutdownCallback;
import com.oracle.libuv.cb.StreamWriteCallback;
import com.oracle.libuv.handles.Handle;
import com.oracle.libuv.handles.LoopHandle;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Objects;

class StreamHandle
extends Handle {
    protected boolean closed = false;
    protected boolean readStarted = false;
    protected StreamReadCallback onRead = null;
    protected StreamWriteCallback onWrite = null;
    protected StreamConnectCallback onConnect = null;
    protected StreamConnectionCallback onConnection = null;
    protected StreamCloseCallback onClose = null;
    protected StreamShutdownCallback onShutdown = null;

    public void setReadCallback(StreamReadCallback callback) {
        this.onRead = callback;
    }

    public void setWriteCallback(StreamWriteCallback callback) {
        this.onWrite = callback;
    }

    public void setConnectCallback(StreamConnectCallback callback) {
        this.onConnect = callback;
    }

    public void setConnectionCallback(StreamConnectionCallback callback) {
        this.onConnection = callback;
    }

    public void setCloseCallback(StreamCloseCallback callback) {
        this.onClose = callback;
    }

    public void setShutdownCallback(StreamShutdownCallback callback) {
        this.onShutdown = callback;
    }

    public void readStart() {
        if (!this.readStarted) {
            this._read_start(this.pointer);
        }
        this.readStarted = true;
    }

    public void readStop() {
        this._read_stop(this.pointer);
        this.readStarted = false;
    }

    private int _write2(String str, Handle handle) {
        byte[] data;
        Objects.requireNonNull(str);
        assert (handle != null);
        try {
            data = str.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this._write2(this.pointer, ByteBuffer.wrap(data), data, 0, data.length, handle.pointer, this.loop.getContext());
    }

    public int write(String str) {
        Objects.requireNonNull(str);
        try {
            return this.write(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int write(String str, String encoding) throws UnsupportedEncodingException {
        Objects.requireNonNull(str);
        byte[] data = str.getBytes(encoding);
        return this.write(ByteBuffer.wrap(data), 0, data.length);
    }

    public int writeLowerBytes(String str) {
        Objects.requireNonNull(str);
        byte[] data = new byte[str.length()];
        str.getBytes(0, data.length, data, 0);
        return this.write(ByteBuffer.wrap(data), 0, data.length);
    }

    public int write(ByteBuffer buffer, int offset, int length) {
        Objects.requireNonNull(buffer);
        return buffer.hasArray() ? this._write(this.pointer, buffer, buffer.array(), offset, length, this.loop.getContext()) : this._write(this.pointer, buffer, null, offset, length, this.loop.getContext());
    }

    public int write(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        return this.write(buffer, 0, buffer.capacity());
    }

    public int closeWrite() {
        return this._close_write(this.pointer, this.loop.getContext());
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    public int listen(int backlog) {
        return this._listen(this.pointer, backlog);
    }

    public int accept(StreamHandle client) {
        return this._accept(this.pointer, client.pointer);
    }

    public boolean isReadable() {
        return this._readable(this.pointer);
    }

    public boolean isWritable() {
        return this._writable(this.pointer);
    }

    public long writeQueueSize() {
        return this._write_queue_size(this.pointer);
    }

    protected StreamHandle(long pointer, LoopHandle loop) {
        super(pointer, loop);
        this._initialize(pointer);
    }

    protected void callRead(ByteBuffer data) {
        if (this.onRead != null) {
            this.loop.getCallbackHandler().handleStreamReadCallback(this.onRead, data);
        }
    }

    protected void callWrite(int status, Exception error, Object context) {
        if (this.onWrite != null) {
            this.loop.getCallbackHandler(context).handleStreamWriteCallback(this.onWrite, status, error);
        }
    }

    protected void callConnect(int status, Exception error, Object context) {
        if (this.onConnect != null) {
            this.loop.getCallbackHandler(context).handleStreamConnectCallback(this.onConnect, status, error);
        }
    }

    protected void callConnection(int status, Exception error) {
        if (this.onConnection != null) {
            this.loop.getCallbackHandler().handleStreamConnectionCallback(this.onConnection, status, error);
        }
    }

    protected void callClose() {
        if (this.onClose != null) {
            this.loop.getCallbackHandler().handleStreamCloseCallback(this.onClose);
        }
    }

    protected void callShutdown(int status, Exception error, Object context) {
        if (this.onShutdown != null) {
            this.loop.getCallbackHandler(context).handleStreamShutdownCallback(this.onShutdown, status, error);
        }
    }

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native void _read_start(long var1);

    private native void _read_stop(long var1);

    private native boolean _readable(long var1);

    private native boolean _writable(long var1);

    private native int _write(long var1, ByteBuffer var3, byte[] var4, int var5, int var6, Object var7);

    private native int _writev(long var1, byte[][] var3, int var4, Object var5);

    private native int _write2(long var1, ByteBuffer var3, byte[] var4, int var5, int var6, long var7, Object var9);

    private native long _write_queue_size(long var1);

    private native void _close(long var1);

    private native int _close_write(long var1, Object var3);

    private native int _listen(long var1, int var3);

    private native int _accept(long var1, long var3);

    static {
        StreamHandle._static_initialize();
    }
}

