/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.CloseCallback;
import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;
import com.oracle.libuv.PrepareCallback;

public class PrepareHandle
extends Handle {
    private boolean closed;
    private PrepareCallback onPrepare;
    private CloseCallback onClose;

    public void setPrepareCallback(PrepareCallback callback) {
        this.onPrepare = callback;
    }

    public void setCloseCallback(CloseCallback callback) {
        this.onClose = callback;
    }

    PrepareHandle(LoopHandle loop) {
        super(PrepareHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public int start() {
        return this._start(this.pointer);
    }

    public int stop() {
        return this._stop(this.pointer);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    private void callback(int type, int status) {
        switch (type) {
            case 1: {
                if (this.onPrepare == null) break;
                this.loop.getCallbackHandler().handlePrepareCallback(this.onPrepare, status);
                break;
            }
            case 2: {
                if (this.onClose == null) break;
                this.loop.getCallbackHandler().handlePrepareCallback(this.onClose, status);
                break;
            }
            default: {
                assert (false) : "unsupported callback type " + type;
                break;
            }
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _start(long var1);

    private native int _stop(long var1);

    private native void _close(long var1);

    static {
        PrepareHandle._static_initialize();
    }
}

