/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.StreamHandle;

public final class StdioOptions {
    private final StdioType type;
    private final StreamHandle stream;
    private final int fd;

    public StdioOptions(StdioType type, StreamHandle stream, int fd) {
        this.type = type;
        this.stream = stream;
        this.fd = fd;
    }

    public int type() {
        if (this.type != null) {
            return this.type.value;
        }
        return StdioType.IGNORE.value;
    }

    public long stream() {
        if (this.stream != null) {
            return this.stream.pointer;
        }
        return 0L;
    }

    public int fd() {
        return this.fd;
    }

    public static enum StdioType {
        IGNORE(0),
        CREATE_PIPE(1),
        INHERIT_FD(2),
        INHERIT_STREAM(4);

        final int value;

        private StdioType(int value) {
            this.value = value;
        }
    }
}

