/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

public class LibUVConfiguration {
    private Boolean useDirectByteBuffer;
    private Boolean copyBuffer;

    public static Builder builder() {
        return new Builder();
    }

    public Boolean useDirectByteBuffer() {
        return this.useDirectByteBuffer;
    }

    public Boolean copyBuffer() {
        return this.copyBuffer;
    }

    public String toString() {
        return "LibUVConfiguration [useDirectByteBuffer=" + this.useDirectByteBuffer + ", copyBuffer=" + this.copyBuffer + "]";
    }

    public static class Builder {
        private Boolean useDirectByteBuffer;
        private Boolean copyBuffer;

        public Builder useDirectByteBuffer(Boolean useDirectByteBuffer) {
            this.useDirectByteBuffer = useDirectByteBuffer;
            return this;
        }

        public Builder copyBuffer(Boolean copyBuffer) {
            this.copyBuffer = copyBuffer;
            return this;
        }

        public LibUVConfiguration build() {
            LibUVConfiguration configuration = new LibUVConfiguration();
            if (this.copyBuffer == null) {
                this.copyBuffer = Boolean.TRUE;
            }
            if (this.useDirectByteBuffer == null) {
                this.useDirectByteBuffer = Boolean.FALSE;
            }
            configuration.useDirectByteBuffer = this.useDirectByteBuffer;
            configuration.copyBuffer = this.copyBuffer;
            return configuration;
        }
    }
}

