/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;
import com.oracle.libuv.StreamCloseCallback;
import com.oracle.libuv.StreamConnectCallback;
import com.oracle.libuv.StreamConnectionCallback;
import com.oracle.libuv.StreamReadCallback;
import com.oracle.libuv.StreamShutdownCallback;
import com.oracle.libuv.StreamWriteCallback;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

class StreamHandle
extends Handle {
    protected boolean closed = false;
    protected boolean readStarted = false;
    protected StreamReadCallback onRead;
    protected StreamWriteCallback onWrite;
    protected StreamConnectCallback onConnect;
    protected StreamConnectionCallback onConnection;
    protected StreamCloseCallback onClose;
    protected StreamShutdownCallback onShutdown;

    public void setReadCallback(StreamReadCallback callback) {
        this.onRead = callback;
    }

    public void setWriteCallback(StreamWriteCallback callback) {
        this.onWrite = callback;
    }

    public void setConnectCallback(StreamConnectCallback callback) {
        this.onConnect = callback;
    }

    public void setConnectionCallback(StreamConnectionCallback callback) {
        this.onConnection = callback;
    }

    public void setCloseCallback(StreamCloseCallback callback) {
        this.onClose = callback;
    }

    public void setShutdownCallback(StreamShutdownCallback callback) {
        this.onShutdown = callback;
    }

    public void readStart() {
        if (!this.readStarted) {
            this._read_start(this.pointer);
        }
        this.readStarted = true;
    }

    public void readStop() {
        this._read_stop(this.pointer);
        this.readStarted = false;
    }

    public int write(String str) {
        Objects.requireNonNull(str);
        return this.write(str, StandardCharsets.UTF_8);
    }

    public int write(String str, Charset encoding) {
        Objects.requireNonNull(str);
        byte[] data = str.getBytes(encoding);
        return this.write(ByteBuffer.wrap(data), 0, data.length);
    }

    public int write(ByteBuffer buffer, int offset, int length) {
        Objects.requireNonNull(buffer);
        if (buffer.hasArray()) {
            return this._write(this.pointer, buffer, buffer.array(), offset, length, this.loop.getContext());
        }
        return this._write(this.pointer, buffer, null, offset, length, this.loop.getContext());
    }

    public int write(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        return this.write(buffer, 0, buffer.capacity());
    }

    public int closeWrite() {
        return this._close_write(this.pointer, this.loop.getContext());
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    public int listen(int backlog) {
        return this._listen(this.pointer, backlog);
    }

    public int accept(StreamHandle client) {
        return this._accept(this.pointer, client.pointer);
    }

    public boolean isReadable() {
        return this._readable(this.pointer);
    }

    public boolean isWritable() {
        return this._writable(this.pointer);
    }

    public long writeQueueSize() {
        return this._write_queue_size(this.pointer);
    }

    StreamHandle(long pointer, LoopHandle loop) {
        super(pointer, loop);
        this._initialize(pointer);
    }

    protected void callRead(ByteBuffer data) {
        if (this.onRead != null) {
            this.loop.getCallbackHandler().handleStreamReadCallback(this.onRead, data);
        }
    }

    protected void callWrite(int status, Exception error, Object context) {
        if (this.onWrite != null) {
            this.loop.getCallbackHandler(context).handleStreamWriteCallback(this.onWrite, status, error);
        }
    }

    protected void callConnect(int status, Exception error, Object context) {
        if (this.onConnect != null) {
            this.loop.getCallbackHandler(context).handleStreamConnectCallback(this.onConnect, status, error);
        }
    }

    protected void callConnection(int status, Exception error) {
        if (this.onConnection != null) {
            this.loop.getCallbackHandler().handleStreamConnectionCallback(this.onConnection, status, error);
        }
    }

    protected void callClose() {
        if (this.onClose != null) {
            this.loop.getCallbackHandler().handleStreamCloseCallback(this.onClose);
        }
    }

    protected void callShutdown(int status, Exception error, Object context) {
        if (this.onShutdown != null) {
            this.loop.getCallbackHandler(context).handleStreamShutdownCallback(this.onShutdown, status, error);
        }
    }

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native void _read_start(long var1);

    private native void _read_stop(long var1);

    private native boolean _readable(long var1);

    private native boolean _writable(long var1);

    private native int _write(long var1, ByteBuffer var3, byte[] var4, int var5, int var6, Object var7);

    private native int _writev(long var1, byte[][] var3, int var4, Object var5);

    private native long _write_queue_size(long var1);

    private native void _close(long var1);

    private native int _close_write(long var1, Object var3);

    private native int _listen(long var1, int var3);

    private native int _accept(long var1, long var3);

    static {
        StreamHandle._static_initialize();
    }
}

