/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.Address;
import com.oracle.libuv.LoopHandle;
import com.oracle.libuv.StreamHandle;
import com.oracle.libuv.TcpFlags;
import java.util.EnumSet;
import java.util.Objects;

public class TCPHandle
extends StreamHandle {
    TCPHandle(LoopHandle loop) {
        super(TCPHandle._new(loop.pointer()), loop);
    }

    public int bind(String address, int port, boolean ipv6) {
        return this.bind(address, port, ipv6, EnumSet.noneOf(TcpFlags.class));
    }

    public int bind(String address, int port, boolean ipv6, EnumSet<TcpFlags> flags) {
        Objects.requireNonNull(address);
        int flagValue = 0;
        for (TcpFlags next : flags) {
            flagValue |= next.value;
        }
        return this.bind(address, port, ipv6, flagValue);
    }

    public int bind(String address, int port, boolean ipv6, int flags) {
        return this._bind(this.pointer, address, port, ipv6, flags);
    }

    public int connect(String address, int port, boolean ipv6) {
        Objects.requireNonNull(address);
        return this._connect(this.pointer, address, port, this.loop.getContext(), ipv6);
    }

    @Override
    public int listen(int backlog) {
        return super.listen(backlog);
    }

    @Override
    public int accept(StreamHandle client) {
        Objects.requireNonNull(client);
        assert (client instanceof TCPHandle);
        int accepted = super.accept(client);
        return accepted;
    }

    public Address getSocketName() {
        return this._socket_name(this.pointer);
    }

    public Address getPeerName() {
        return this._peer_name(this.pointer);
    }

    public int setNoDelay(boolean enable) {
        return this._no_delay(this.pointer, enable ? 1 : 0);
    }

    public int setKeepAlive(boolean enable, int delay) {
        return this._keep_alive(this.pointer, enable ? 1 : 0, delay);
    }

    public int setSimultaneousAccepts(boolean enable) {
        return this._simultaneous_accepts(this.pointer, enable ? 1 : 0);
    }

    private static native long _new(long var0);

    private native int _bind(long var1, String var3, int var4, boolean var5, int var6);

    private native int _connect(long var1, String var3, int var4, Object var5, boolean var6);

    private native int _open(long var1, long var3);

    private native Address _socket_name(long var1);

    private native Address _peer_name(long var1);

    private native int _no_delay(long var1, int var3);

    private native int _keep_alive(long var1, int var3, int var4);

    private native int _simultaneous_accepts(long var1, int var3);
}

