/*
 * Decompiled with CFR 0.152.
 */
package link.jfire.codejson;

import java.lang.reflect.Type;
import java.util.Stack;
import link.jfire.baseutil.collection.StringCache;
import link.jfire.baseutil.reflect.ReflectUtil;
import link.jfire.baseutil.verify.Verify;
import link.jfire.codejson.Json;
import link.jfire.codejson.JsonArray;
import link.jfire.codejson.JsonObject;
import link.jfire.codejson.function.ReaderContext;
import link.jfire.codejson.function.WriterContext;
import sun.misc.Unsafe;

public class JsonTool {
    private static long valueOff = ReflectUtil.getFieldOffset((String)"value", String.class);
    private static Unsafe unsafe = ReflectUtil.getUnsafe();
    private static ThreadLocal<StringCache> cacheLocal = new ThreadLocal<StringCache>(){

        @Override
        protected StringCache initialValue() {
            return new StringCache(2048);
        }
    };

    public static String write(Object value) {
        StringCache cache = cacheLocal.get();
        cache.clear();
        WriterContext.write(value, cache);
        return cache.toString();
    }

    public static <T> T read(Type entityClass, String str) {
        return (T)ReaderContext.getReader(entityClass).read(entityClass, JsonTool.fromString(str));
    }

    public static <T> T read(Type entityClass, Json json) {
        return (T)ReaderContext.getReader(entityClass).read(entityClass, json);
    }

    public static Json fromString(String str) {
        Stack<Cloneable> jsonStack = new Stack<Cloneable>();
        Stack<String> keyStack = new Stack<String>();
        int flag = 0;
        int index = 0;
        int length = str.length();
        char[] array = (char[])unsafe.getObject(str, valueOff);
        boolean strStartRead = false;
        boolean isJsonObject = false;
        String jsonKey = null;
        block10: while (index < length) {
            char c = array[index];
            switch (c) {
                case '/': {
                    if (array[index + 1] != '*') break;
                    int end = str.indexOf("*/", index);
                    if (end == -1) {
                        throw new RuntimeException("json\u5b57\u7b26\u4e32\u5b58\u5728\u95ee\u9898");
                    }
                    index = end + 2;
                    flag = flag == 0 ? 0 : index;
                    continue block10;
                }
                case '{': {
                    jsonStack.push(new JsonObject());
                    isJsonObject = true;
                    if (jsonKey == null) break;
                    keyStack.push(jsonKey);
                    jsonKey = null;
                    flag = 0;
                    break;
                }
                case '}': {
                    Object ahead;
                    if (flag != 0) {
                        Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                        if (value != null) {
                            ((JsonObject)jsonStack.peek()).put(jsonKey, value);
                        }
                        jsonKey = null;
                        flag = 0;
                    }
                    if (jsonStack.size() > 1) {
                        Json json = (Json)jsonStack.pop();
                        ahead = jsonStack.peek();
                        if (ahead.getClass().equals(JsonObject.class)) {
                            ((JsonObject)ahead).put(keyStack.pop(), json);
                            isJsonObject = true;
                            break;
                        }
                        ((JsonArray)ahead).add(json);
                        isJsonObject = false;
                        break;
                    }
                    return (Json)jsonStack.pop();
                }
                case '[': {
                    jsonStack.push(new JsonArray());
                    isJsonObject = false;
                    if (jsonKey != null) {
                        keyStack.push(jsonKey);
                        jsonKey = null;
                        flag = index + 1;
                        break;
                    }
                    flag = index + 1;
                    break;
                }
                case ']': {
                    Object ahead;
                    if (flag != 0 && flag != index) {
                        Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                        if (value != null) {
                            ((JsonArray)jsonStack.peek()).add(value);
                        }
                        flag = 0;
                    }
                    if (jsonStack.size() > 1) {
                        JsonArray jsonArray = (JsonArray)jsonStack.pop();
                        ahead = jsonStack.peek();
                        if (ahead instanceof JsonObject) {
                            ((JsonObject)ahead).put(keyStack.pop(), jsonArray);
                            isJsonObject = true;
                        } else {
                            ((JsonArray)ahead).add(jsonArray);
                            isJsonObject = false;
                        }
                        flag = 0;
                        break;
                    }
                    return (Json)jsonStack.pop();
                }
                case '\"': {
                    int end = str.indexOf(34, ++index);
                    Verify.True((end != -1 ? 1 : 0) != 0, (String)"json\u5b57\u7b26\u4e32\u5b58\u5728\u5f02\u5e38", (Object[])new Object[0]);
                    if (isJsonObject) {
                        if (jsonKey == null) {
                            jsonKey = str.substring(index, end);
                        } else {
                            ((JsonObject)jsonStack.peek()).put(jsonKey, str.substring(index, end));
                            jsonKey = null;
                        }
                    } else {
                        ((JsonArray)jsonStack.peek()).add(str.substring(index, end));
                    }
                    flag = 0;
                    strStartRead = false;
                    index = end + 1;
                    continue block10;
                }
                case ':': {
                    if (strStartRead || flag != 0) break;
                    flag = index + 1;
                    break;
                }
                case ',': {
                    if (strStartRead || flag == 0) break;
                    Object value = JsonTool.getNotStrValue(flag, index - 1, array);
                    if (isJsonObject) {
                        if (value != null) {
                            ((JsonObject)jsonStack.peek()).put(jsonKey, value);
                        }
                        jsonKey = null;
                        flag = 0;
                        break;
                    }
                    if (value != null) {
                        ((JsonArray)jsonStack.peek()).add(value);
                    }
                    flag = index + 1;
                    break;
                }
            }
            ++index;
        }
        throw new RuntimeException("json\u5b57\u7b26\u4e32\u5b58\u5728\u9519\u8bef");
    }

    private static Object getNotStrValue(int flag, int index, char[] value) {
        block12: while (true) {
            switch (value[flag]) {
                case ' ': {
                    ++flag;
                    continue block12;
                }
                case '\t': {
                    ++flag;
                    continue block12;
                }
                case '\r': {
                    ++flag;
                    continue block12;
                }
                case '\n': {
                    ++flag;
                    continue block12;
                }
            }
            break;
        }
        block13: while (true) {
            switch (value[index]) {
                case ' ': {
                    --index;
                    continue block13;
                }
                case '\t': {
                    --index;
                    continue block13;
                }
                case '\r': {
                    --index;
                    continue block13;
                }
                case '\n': {
                    --index;
                    continue block13;
                }
            }
            break;
        }
        String tmp = new String(value, flag, index - flag + 1);
        if (tmp.equals("true")) {
            return Boolean.TRUE;
        }
        if (tmp.equals("false")) {
            return Boolean.FALSE;
        }
        if (tmp.equals("null")) {
            return null;
        }
        if (tmp.contains(".")) {
            return Double.valueOf(tmp);
        }
        if (tmp.equals("{")) {
            return null;
        }
        return Long.valueOf(tmp);
    }

    public static String toString(Object value) {
        return JsonTool.write(value);
    }
}

