/*
 * Decompiled with CFR 0.152.
 */
package link.jfire.codejson.function;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import link.jfire.baseutil.collection.StringCache;
import link.jfire.baseutil.reflect.ReflectUtil;
import link.jfire.codejson.function.JsonReader;
import link.jfire.codejson.function.impl.read.ObjectReader;
import link.jfire.codejson.function.impl.read.array.BooleanArrayReader;
import link.jfire.codejson.function.impl.read.array.ByteArrayReader;
import link.jfire.codejson.function.impl.read.array.CharArrayReader;
import link.jfire.codejson.function.impl.read.array.DoubleArrayReader;
import link.jfire.codejson.function.impl.read.array.FloatArrayReader;
import link.jfire.codejson.function.impl.read.array.IntArrayReader;
import link.jfire.codejson.function.impl.read.array.LongArrayReader;
import link.jfire.codejson.function.impl.read.array.ShortArrayReader;
import link.jfire.codejson.function.impl.read.array.StringArrayReader;
import link.jfire.codejson.function.impl.read.wrapper.BooleanReader;
import link.jfire.codejson.function.impl.read.wrapper.ByteReader;
import link.jfire.codejson.function.impl.read.wrapper.CharacterReader;
import link.jfire.codejson.function.impl.read.wrapper.DoubleReader;
import link.jfire.codejson.function.impl.read.wrapper.FloatReader;
import link.jfire.codejson.function.impl.read.wrapper.IntegerReader;
import link.jfire.codejson.function.impl.read.wrapper.LongReader;
import link.jfire.codejson.function.impl.read.wrapper.ShortReader;
import link.jfire.codejson.methodinfo.MethodInfoBuilder;
import link.jfire.codejson.methodinfo.ReadMethodInfo;
import link.jfire.codejson.strategy.ReadStrategy;
import link.jfire.codejson.util.NameTool;

public class ReaderContext {
    private static Map<Type, JsonReader> readerMap = new ConcurrentHashMap<Type, JsonReader>();
    private static ClassPool classPool = ClassPool.getDefault();
    private static Set<Class<?>> wrapperSet = new HashSet();

    public static Object read(Type entityType, Object value) {
        return ReaderContext.getReader(entityType).read(entityType, value);
    }

    public static JsonReader getReader(Type ckass) {
        JsonReader reader = readerMap.get(ckass);
        if (reader == null) {
            try {
                reader = (JsonReader)ReaderContext.createReader(ckass, null).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            readerMap.put(ckass, reader);
        }
        return reader;
    }

    private static Class<?> createReader(Type type, ReadStrategy strategy) {
        String body = null;
        if (type instanceof Class) {
            Class tmp = (Class)type;
            if (tmp.isArray()) {
                body = ReaderContext.buildArrayReader(tmp);
            } else {
                StringCache stringCache = new StringCache();
                stringCache.append("{\n" + tmp.getName() + " entity = (" + tmp.getName() + ")(((Class)$1).newInstance());\n");
                stringCache.append("JsonObject json = (JsonObject)$2;\n");
                for (Method each : ReflectUtil.listSetMethod((Class)tmp)) {
                    ReadMethodInfo methodInfo = MethodInfoBuilder.buildReadMethodInfo(each, strategy);
                    stringCache.append(methodInfo.getOutput());
                }
                stringCache.append("return entity;\n}");
                body = stringCache.toString();
            }
            return ReaderContext.buildClass(body, tmp);
        }
        if (type instanceof ParameterizedType) {
            Class targetClass = (Class)((ParameterizedType)type).getRawType();
            if (targetClass.isInterface() || Modifier.isAbstract(targetClass.getModifiers())) {
                throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u5177\u4f53\u7684\u7c7b\u4fe1\u606f\uff0c\u4e0d\u80fd\u662f\u63a5\u53e3\u6216\u8005\u662f\u62bd\u8c61\u7c7b");
            }
            if (Collection.class.isAssignableFrom(targetClass)) {
                Type paramType = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (type instanceof WildcardType) {
                    throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
                }
                body = ReaderContext.buildCollectionReader(targetClass, paramType);
            } else if (Map.class.isAssignableFrom(targetClass)) {
                Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Type valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                if (keyType instanceof WildcardType || valueType instanceof WildcardType) {
                    throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
                }
                body = ReaderContext.buildMapReader(targetClass, keyType, valueType);
            }
            return ReaderContext.buildClass(body, targetClass);
        }
        if (type instanceof GenericArrayType) {
            Type root = type;
            while (root instanceof GenericArrayType) {
                root = ((GenericArrayType)root).getGenericComponentType();
            }
            if (root instanceof WildcardType) {
                throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u786e\u5b9a\u7684\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
            }
            body = ReaderContext.buildArrayReader(type);
            if (root instanceof ParameterizedType) {
                root = ((ParameterizedType)root).getRawType();
            }
            return ReaderContext.buildClass(body, (Class)root);
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u786e\u5b9a\u7684\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f7f\u7528\uff1f\u6cdb\u578b\u53c2\u6570");
        }
        throw new RuntimeException("\u672a\u77e5\u60c5\u51b5");
    }

    private static Class<?> buildClass(String body, Class<?> targetClass) {
        try {
            CtClass implClass = classPool.makeClass("JsonReader_" + targetClass.getSimpleName() + "_" + System.nanoTime());
            CtClass interfaceCtClass = classPool.getCtClass(JsonReader.class.getName());
            implClass.setInterfaces(new CtClass[]{interfaceCtClass});
            CtMethod method = new CtMethod(classPool.get(Object.class.getName()), "read", new CtClass[]{classPool.get(Type.class.getName()), classPool.get(Object.class.getName())}, implClass);
            method.setBody(body);
            implClass.addMethod(method);
            implClass.stopPruning(false);
            implClass.rebuildClassFile();
            return implClass.toClass();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildArrayReader(Type targetClass) {
        int i;
        String rootName = null;
        int dim = 0;
        if (targetClass instanceof Class) {
            Class<?> rootType = (Class<?>)targetClass;
            dim = 0;
            while (rootType.isArray()) {
                ++dim;
                rootType = rootType.getComponentType();
            }
            rootName = rootType.getName();
        } else {
            Type root = targetClass;
            dim = 0;
            while (root instanceof GenericArrayType) {
                ++dim;
                root = ((GenericArrayType)root).getGenericComponentType();
            }
            if (root instanceof ParameterizedType) {
                if (!((root = ((ParameterizedType)root).getRawType()) instanceof Class)) throw new RuntimeException("\u53cd\u5e8f\u5217\u5316\u9700\u8981\u7684\u7c7b\u5b9a\u4e49\u4fe1\u606f\u4e0d\u660e\u786e");
                rootName = ((Class)root).getName();
            } else {
                rootName = ((Class)root).getName();
            }
        }
        String str = "{\n\tJsonArray jsonArray" + dim + " = ((JsonArray)$2);\n";
        str = str + "\tint l" + dim + " = jsonArray" + dim + ".size();\n";
        str = str + "\t" + NameTool.buildDimTypeName(rootName, dim) + " array" + dim + " = " + NameTool.buildNewDimTypeName(rootName, dim, "l" + dim) + ";\n";
        str = str + "\tfor(int i" + dim + " = 0;i" + dim + "<l" + dim + ";i" + dim + "++)\n";
        str = str + "\t{\n";
        String bk = "\t\t";
        for (i = dim - 1; i > 0; --i) {
            str = str + bk + "JsonArray jsonArray" + i + " =jsonArray" + (i + 1) + ".getJsonArray(i" + (i + 1) + ");\n";
            str = str + bk + "int l" + i + " = jsonArray" + i + ".size();\n";
            str = str + bk + NameTool.buildDimTypeName(rootName, i) + " array" + i + " = " + NameTool.buildNewDimTypeName(rootName, i, "l" + i) + ";\n";
            str = str + bk + "for(int i" + i + " = 0;i" + i + "<l" + i + ";i" + i + "++)\n";
            str = str + bk + "{\n";
            bk = bk + "\t";
        }
        if (!(targetClass instanceof Class)) throw new RuntimeException("javassist\u4e0d\u652f\u6301\u6cdb\u578b\u53c2\u6570\uff0c\u65e0\u6cd5\u5b8c\u6210\u8be5\u5bf9\u8c61\u7684");
        str = str + bk + "array1[i1] = (" + rootName + ")ReaderContext.read(" + rootName + ".class,jsonArray1.get(i1));\n";
        for (i = 1; i <= dim - 1; ++i) {
            bk = bk.substring(0, bk.length() - 1);
            str = str + bk + "}\n";
            str = str + bk + "array" + (i + 1) + "[i" + (i + 1) + "] = array" + i + ";\n";
        }
        str = str + "\t}\n";
        str = str + "\treturn array" + dim + ";\n";
        return str + "}";
    }

    private static String buildCollectionReader(Class<?> collectionClass, Type paramType) {
        String str = "{\n\t" + collectionClass.getName() + " collection = new " + collectionClass.getName() + "();\n";
        str = str + "\tJsonArray jsonArray = (JsonArray)$2;\n";
        str = str + "\tint size = jsonArray.size();\n";
        str = str + "\tfor(int i=0;i<size;i++)\n";
        str = str + "\t{\n";
        if (wrapperSet.contains(paramType)) {
            str = str + "\t\tcollection.add(jsonArray.getW" + ((Class)paramType).getSimpleName() + "(i));\n";
        } else if (paramType instanceof Class) {
            str = str + "\t\tcollection.add(ReaderContext.read(" + ((Class)paramType).getName() + ".class,jsonArray.get(i)));\n";
        } else if (paramType instanceof Type) {
            str = str + "\t\tcollection.add(ReaderContext.read(new TypeUtil<" + String.valueOf(paramType) + ">(){}.getType(),jsonArray.get(i));\n";
        } else {
            throw new RuntimeException("\u672a\u77e5\u9519\u8bef");
        }
        str = str + "\t}\n";
        str = str + "\treturn collection;\n";
        str = str + "}";
        return str;
    }

    private static String buildMapReader(Class<?> mapClass, Type keyType, Type valueType) {
        Class tmp;
        String str = "{\n\t" + mapClass.getName() + " map = new " + mapClass.getName() + "();\n";
        str = str + "\tJsonObject jsonObject = (JsonObject)$2;\n";
        str = str + "\tint size = jsonObject.size();\n";
        str = str + "\tIterator it = jsonObject.entrySet().iterator();\n";
        str = str + "\tObject key = null;\n";
        str = str + "\tObject value = null;\n";
        str = str + "\twhile(it.hasNext())\n";
        str = str + "\t{\n";
        str = str + "\t\tjava.util.Map.Entry each = (java.util.Map.Entry)it.next();\n";
        if (keyType instanceof Class) {
            str = ((Class)keyType).equals(String.class) ? str + "\t\tkey = (String)each.getKey();\n" : (((Class)keyType).equals(Character.class) ? str + "\t\tkey = ((String)each.getKey()).charAt(0);\n" : (wrapperSet.contains(keyType) ? str + "\t\tkey = " + ((Class)keyType).getName() + ".valueOf((String)each.getKey());\n" : str + "\t\tkey = ReaderContext.read(" + ((Class)keyType).getName() + ".class,(String)each.getKey());\n"));
        } else {
            throw new RuntimeException("\u6682\u65f6\u8d85\u51fa\u5904\u7406\u903b\u8f91\uff0c\u8bf7\u53d1\u90ae\u4ef6\u7ed9\u4f5c\u8005eric@jfire.cn");
        }
        str = valueType instanceof Class ? ((tmp = (Class)valueType).equals(String.class) ? str + "\t\tvalue = (String)each.getValue();\n" : (tmp.equals(Character.class) ? str + "\t\tvalue = ((String)each.getValue()).charAt(0);\n" : (wrapperSet.contains(tmp) ? str + "\t\tvalue = jsonObject.getW" + tmp.getSimpleName() + "(each.getKey());\n" : str + "\t\tvalue = ReaderContext.read(" + tmp.getName() + ".class,each.getValue());\n"))) : str + "\t\tvalue = ReaderContext.read(new TypeUtil<" + String.valueOf(valueType) + ">(){}.getType(),each.getValue());\n";
        str = str + "\t\tmap.put(key,value);\n";
        str = str + "\t}\n";
        str = str + "\treturn map;";
        str = str + "}";
        return str;
    }

    public static void putReader(Class<?> ckass, JsonReader jsonReader) {
        readerMap.put(ckass, jsonReader);
    }

    static {
        wrapperSet.add(String.class);
        wrapperSet.add(Boolean.class);
        wrapperSet.add(Integer.class);
        wrapperSet.add(Long.class);
        wrapperSet.add(Short.class);
        wrapperSet.add(Float.class);
        wrapperSet.add(Double.class);
        wrapperSet.add(Short.class);
        wrapperSet.add(Byte.class);
        wrapperSet.add(Character.class);
        wrapperSet.equals(String.class);
        ClassPool.doPruning = true;
        classPool.insertClassPath((ClassPath)new ClassClassPath(ReaderContext.class));
        classPool.importPackage("link.jfire.codejson.function");
        classPool.importPackage("link.jfire.codejson.stringpattern");
        classPool.importPackage("link.jfire.codejson");
        classPool.importPackage("java.util");
        classPool.importPackage("link.jfire.baseutil.collection");
        readerMap.put((Type)((Object)Boolean.class), new BooleanReader());
        readerMap.put((Type)((Object)Byte.class), new ByteReader());
        readerMap.put((Type)((Object)Character.class), new CharacterReader());
        readerMap.put((Type)((Object)Double.class), new DoubleReader());
        readerMap.put((Type)((Object)Float.class), new FloatReader());
        readerMap.put((Type)((Object)Integer.class), new IntegerReader());
        readerMap.put((Type)((Object)Long.class), new LongReader());
        readerMap.put((Type)((Object)Short.class), new ShortReader());
        readerMap.put((Type)((Object)int[].class), new IntArrayReader());
        readerMap.put((Type)((Object)byte[].class), new ByteArrayReader());
        readerMap.put((Type)((Object)boolean[].class), new BooleanArrayReader());
        readerMap.put((Type)((Object)char[].class), new CharArrayReader());
        readerMap.put((Type)((Object)long[].class), new LongArrayReader());
        readerMap.put((Type)((Object)short[].class), new ShortArrayReader());
        readerMap.put((Type)((Object)float[].class), new FloatArrayReader());
        readerMap.put((Type)((Object)double[].class), new DoubleArrayReader());
        readerMap.put((Type)((Object)String[].class), new StringArrayReader());
        readerMap.put((Type)((Object)Object.class), new ObjectReader());
    }
}

