/*
 * Decompiled with CFR 0.152.
 */
package link.jfire.codejson.methodinfo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import link.jfire.codejson.methodinfo.ReadMethodInfo;
import link.jfire.codejson.methodinfo.WriteMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.SetBaseMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.SetCollectionMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.SetCustomObjectMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.SetMapMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.SetWrapperMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.array.SetBaseArrayMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.array.SetCollectionArrayMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.array.SetCustomArrayMethodInfo;
import link.jfire.codejson.methodinfo.impl.read.array.SetWarpperArrayMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.ReturnBaseMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.ReturnCustomObjectMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.ReturnIterableMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.ReturnMapMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.ReturnWrapperMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.array.ReturnArrayBaseMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.array.ReturnArrayCustomObjectMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.array.ReturnArrayIterableMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.array.ReturnArrayMapMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.array.ReturnArrayWrapperMethodInfo;
import link.jfire.codejson.methodinfo.impl.write.extra.ReturnArrayListMethodInfo;
import link.jfire.codejson.strategy.ReadStrategy;
import link.jfire.codejson.strategy.WriteStrategy;

public class MethodInfoBuilder {
    public static Set<Class<?>> wrapperSet = new HashSet();

    public static WriteMethodInfo buildWriteMethodInfo(Method method, WriteStrategy strategy, String entityName) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray()) {
            return MethodInfoBuilder.buildWriteArray(method, strategy, entityName);
        }
        return MethodInfoBuilder.buildWriteSingle(method, strategy, entityName);
    }

    private static WriteMethodInfo buildWriteArray(Method method, WriteStrategy strategy, String entityName) {
        Class<?> resultType = method.getReturnType();
        Class<?> rootType = MethodInfoBuilder.getRootType(resultType);
        if (rootType.isPrimitive()) {
            return new ReturnArrayBaseMethodInfo(method, strategy, entityName);
        }
        if (wrapperSet.contains(rootType)) {
            return new ReturnArrayWrapperMethodInfo(method, strategy, entityName);
        }
        if (Iterable.class.isAssignableFrom(rootType)) {
            return new ReturnArrayIterableMethodInfo(method, strategy, entityName);
        }
        if (Map.class.isAssignableFrom(rootType)) {
            return new ReturnArrayMapMethodInfo(method, strategy, entityName);
        }
        return new ReturnArrayCustomObjectMethodInfo(method, strategy, entityName);
    }

    private static Class<?> getRootType(Class<?> type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    private static WriteMethodInfo buildWriteSingle(Method method, WriteStrategy strategy, String entityName) {
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            return new ReturnBaseMethodInfo(method, strategy, entityName);
        }
        if (wrapperSet.contains(returnType)) {
            return new ReturnWrapperMethodInfo(method, strategy, entityName);
        }
        if (ArrayList.class.isAssignableFrom(returnType)) {
            return new ReturnArrayListMethodInfo(method, strategy, entityName);
        }
        if (Iterable.class.isAssignableFrom(returnType)) {
            return new ReturnIterableMethodInfo(method, strategy, entityName);
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return new ReturnMapMethodInfo(method, strategy, entityName);
        }
        return new ReturnCustomObjectMethodInfo(method, strategy, entityName);
    }

    public static ReadMethodInfo buildReadMethodInfo(Method method, ReadStrategy strategy) {
        if (MethodInfoBuilder.getParamType(method).isArray()) {
            return MethodInfoBuilder.buildArrayRead(method, strategy);
        }
        return MethodInfoBuilder.buildSingleRead(method, strategy);
    }

    private static ReadMethodInfo buildSingleRead(Method method, ReadStrategy strategy) {
        Class<?> paramType = MethodInfoBuilder.getParamType(method);
        if (paramType.isPrimitive()) {
            return new SetBaseMethodInfo(method, strategy);
        }
        if (wrapperSet.contains(paramType)) {
            return new SetWrapperMethodInfo(method, strategy);
        }
        if (Collection.class.isAssignableFrom(paramType)) {
            return new SetCollectionMethodInfo(method, strategy);
        }
        if (Map.class.isAssignableFrom(paramType)) {
            return new SetMapMethodInfo(method, strategy);
        }
        return new SetCustomObjectMethodInfo(method, strategy);
    }

    private static ReadMethodInfo buildArrayRead(Method method, ReadStrategy strategy) {
        Class<?> paramType = MethodInfoBuilder.getParamType(method);
        Class<?> rootType = MethodInfoBuilder.getRootType(paramType);
        if (rootType.isPrimitive()) {
            return new SetBaseArrayMethodInfo(method, strategy);
        }
        if (wrapperSet.contains(rootType)) {
            return new SetWarpperArrayMethodInfo(method, strategy);
        }
        if (Collection.class.isAssignableFrom(rootType)) {
            return new SetCollectionArrayMethodInfo(method, strategy);
        }
        return new SetCustomArrayMethodInfo(method, strategy);
    }

    private static Class<?> getParamType(Method method) {
        return method.getParameterTypes()[0];
    }

    static {
        wrapperSet.add(String.class);
        wrapperSet.add(Boolean.class);
        wrapperSet.add(Integer.class);
        wrapperSet.add(Long.class);
        wrapperSet.add(Short.class);
        wrapperSet.add(Float.class);
        wrapperSet.add(Double.class);
        wrapperSet.add(Short.class);
        wrapperSet.add(Byte.class);
        wrapperSet.add(Character.class);
        wrapperSet.equals(String.class);
    }
}

