/*
 * Decompiled with CFR 0.152.
 */
package link.jfire.codejson.strategy;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import link.jfire.baseutil.collection.StringCache;
import link.jfire.codejson.function.JsonWriter;
import link.jfire.codejson.function.WriterContext;
import link.jfire.codejson.function.impl.write.array.BooleanArrayWriter;
import link.jfire.codejson.function.impl.write.array.ByteArrayWriter;
import link.jfire.codejson.function.impl.write.array.CharArrayWriter;
import link.jfire.codejson.function.impl.write.array.DoubleArrayWriter;
import link.jfire.codejson.function.impl.write.array.FloatArrayWriter;
import link.jfire.codejson.function.impl.write.array.IntArrayWriter;
import link.jfire.codejson.function.impl.write.array.LongArrayWriter;
import link.jfire.codejson.function.impl.write.array.ShortArrayWriter;
import link.jfire.codejson.function.impl.write.array.StringArrayWriter;
import link.jfire.codejson.function.impl.write.extra.ArrayListWriter;
import link.jfire.codejson.function.impl.write.extra.DateWriter;
import link.jfire.codejson.function.impl.write.wrapper.BooleanWriter;
import link.jfire.codejson.function.impl.write.wrapper.ByteWriter;
import link.jfire.codejson.function.impl.write.wrapper.CharacterWriter;
import link.jfire.codejson.function.impl.write.wrapper.DoubleWriter;
import link.jfire.codejson.function.impl.write.wrapper.FloatWriter;
import link.jfire.codejson.function.impl.write.wrapper.IntegerWriter;
import link.jfire.codejson.function.impl.write.wrapper.LongWriter;
import link.jfire.codejson.function.impl.write.wrapper.ShortWriter;
import link.jfire.codejson.function.impl.write.wrapper.StringWriter;
import link.jfire.codejson.strategy.Strategy;

public class WriteStrategy
implements Strategy {
    private Map<Class<?>, JsonWriter> typeStrategy = new HashMap();
    private Map<String, JsonWriter> fieldStrategy = new HashMap<String, JsonWriter>();
    private Set<String> ignoreFields = new HashSet<String>();
    private Map<String, String> renameFields = new HashMap<String, String>();
    private JsonWriter writer;
    private ThreadLocal<StringCache> cacheLocal = new ThreadLocal<StringCache>(){

        @Override
        protected StringCache initialValue() {
            return new StringCache();
        }
    };

    public WriteStrategy() {
        this.typeStrategy.put(String.class, new StringWriter());
        this.typeStrategy.put(Double.class, new DoubleWriter());
        this.typeStrategy.put(Float.class, new FloatWriter());
        this.typeStrategy.put(Integer.class, new IntegerWriter());
        this.typeStrategy.put(Long.class, new LongWriter());
        this.typeStrategy.put(Short.class, new ShortWriter());
        this.typeStrategy.put(Boolean.class, new BooleanWriter());
        this.typeStrategy.put(Byte.class, new ByteWriter());
        this.typeStrategy.put(Character.class, new CharacterWriter());
        this.typeStrategy.put(int[].class, new IntArrayWriter());
        this.typeStrategy.put(boolean[].class, new BooleanArrayWriter());
        this.typeStrategy.put(long[].class, new LongArrayWriter());
        this.typeStrategy.put(short[].class, new ShortArrayWriter());
        this.typeStrategy.put(byte[].class, new ByteArrayWriter());
        this.typeStrategy.put(float[].class, new FloatArrayWriter());
        this.typeStrategy.put(double[].class, new DoubleArrayWriter());
        this.typeStrategy.put(char[].class, new CharArrayWriter());
        this.typeStrategy.put(String[].class, new StringArrayWriter());
        this.typeStrategy.put(ArrayList.class, new ArrayListWriter());
        this.typeStrategy.put(java.util.Date.class, new DateWriter());
        this.typeStrategy.put(Date.class, new DateWriter());
    }

    public boolean containsStrategyType(Class<?> type) {
        return this.typeStrategy.containsKey(type);
    }

    public JsonWriter getWriter(Class<?> type) {
        this.writer = this.typeStrategy.get(type);
        if (this.writer == null) {
            this.writer = WriterContext.getWriter(type, this);
            this.typeStrategy.put(type, this.writer);
            return this.writer;
        }
        return this.writer;
    }

    public void addTypeStrategy(Class<?> ckass, JsonWriter jsonWriter) {
        this.typeStrategy.put(ckass, jsonWriter);
    }

    public boolean containsStrategyField(String fieldName) {
        return this.fieldStrategy.containsKey(fieldName);
    }

    public JsonWriter getWriterByField(String fieldName) {
        return this.fieldStrategy.get(fieldName);
    }

    public void addFieldStrategy(String fieldName, JsonWriter writer) {
        this.fieldStrategy.put(fieldName, writer);
    }

    public void addIgnoreField(String fieldName) {
        this.ignoreFields.add(fieldName);
    }

    public boolean ignore(String fieldName) {
        return this.ignoreFields.contains(fieldName);
    }

    public void addRenameField(String originName, String rename) {
        this.renameFields.put(originName, rename);
    }

    @Override
    public String getRename(String fieldName) {
        return this.renameFields.get(fieldName);
    }

    @Override
    public boolean containsRename(String fieldName) {
        return this.renameFields.containsKey(fieldName);
    }

    public String write(Object entity) {
        StringCache cache = this.cacheLocal.get();
        cache.clear();
        this.getWriter(entity.getClass()).write(entity, cache, null);
        return cache.toString();
    }
}

