/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mn.foreman.api.WebUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkWebUtil
implements WebUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JdkWebUtil.class);
    private static final String NO_CONTENT = "";
    private final String apiToken;
    private final String foremanUrl;
    private final int socketTimeoutMillis;

    public JdkWebUtil(String foremanUrl, String apiToken, int socketTimeout, TimeUnit socketTimeoutUnits) {
        this.foremanUrl = foremanUrl;
        this.apiToken = apiToken;
        this.socketTimeoutMillis = (int)socketTimeoutUnits.toMillis(socketTimeout);
    }

    @Override
    public Optional<String> get(String uri) {
        return this.get(uri, Collections.emptyMap());
    }

    @Override
    public Optional<String> get(String uri, boolean auth) {
        return this.readOp(uri, auth, Collections.emptyMap());
    }

    @Override
    public Optional<String> get(String uri, Map<String, String> params) {
        return this.readOp(uri, true, params);
    }

    @Override
    public Optional<String> post(String uri) {
        return this.post(uri, NO_CONTENT);
    }

    @Override
    public Optional<String> post(String uri, String body) {
        HttpPost httpPost = new HttpPost(String.format("%s%s", this.foremanUrl, uri));
        return this.writeableOp(uri, body, (HttpEntityEnclosingRequestBase)httpPost);
    }

    @Override
    public Optional<String> put(String uri, String body) {
        HttpPut httpPut = new HttpPut(String.format("%s%s", this.foremanUrl, uri));
        return this.writeableOp(uri, body, (HttpEntityEnclosingRequestBase)httpPut);
    }

    private Optional<String> readOp(String uri, boolean auth, Map<String, String> params) {
        String response = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.socketTimeoutMillis).setConnectionRequestTimeout(this.socketTimeoutMillis).setSocketTimeout(this.socketTimeoutMillis).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).disableAutomaticRetries().build();){
            HttpGet httpGet = new HttpGet(String.format("%s%s", this.foremanUrl, uri));
            URIBuilder uriBuilder = new URIBuilder(httpGet.getURI());
            if (!params.isEmpty()) {
                params.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
            }
            httpGet.setURI(uriBuilder.build());
            LOG.debug("Querying {}{}", (Object)this.foremanUrl, (Object)uri);
            if (auth) {
                httpGet.setHeader("Authorization", "Token " + this.apiToken);
            }
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    LOG.debug("Obtained response from Foreman: {}", (Object)response);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Exception occurred while GETing", (Throwable)ioe);
            }
        }
        catch (IOException | URISyntaxException ioe) {
            LOG.warn("Exception occurred while GETing", (Throwable)ioe);
        }
        return Optional.ofNullable(response);
    }

    private Optional<String> writeableOp(String uri, String body, HttpEntityEnclosingRequestBase requestBase) {
        String response = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.socketTimeoutMillis).setConnectionRequestTimeout(this.socketTimeoutMillis).setSocketTimeout(this.socketTimeoutMillis).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).disableAutomaticRetries().build();){
            StringEntity stringEntity = new StringEntity(body);
            LOG.debug("Querying {}{} with {}", new Object[]{this.foremanUrl, uri, body});
            requestBase.setEntity((HttpEntity)stringEntity);
            requestBase.setHeader("Content-Type", "application/json");
            requestBase.setHeader("Authorization", "Token " + this.apiToken);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)requestBase);){
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    LOG.debug("Obtained response from Foreman: {}", (Object)response);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Exception occurred while posting", (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception occurred while posting", (Throwable)ioe);
        }
        return Optional.ofNullable(response);
    }
}

