/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api.endpoints.miners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mn.foreman.api.JsonUtils;
import mn.foreman.api.WebUtil;
import mn.foreman.api.endpoints.miners.Miners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinersImpl
implements Miners {
    private static final Logger LOG = LoggerFactory.getLogger(MinersImpl.class);
    private final String clientId;
    private final ObjectMapper objectMapper;
    private final String pickaxeId;
    private final WebUtil webUtil;

    public MinersImpl(String clientId, String pickaxeId, ObjectMapper objectMapper, WebUtil webUtil) {
        this.clientId = clientId;
        this.pickaxeId = pickaxeId;
        this.objectMapper = objectMapper;
        this.webUtil = webUtil;
    }

    @Override
    public List<Miners.Miner> all() {
        return this.webUtil.get(String.format("/api/miners/%s/%s", this.clientId, this.pickaxeId)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<List<Miners.Miner>>(){})).orElse(Collections.emptyList());
    }

    @Override
    public Optional<Miners.Miner> one(int minerId) {
        return this.webUtil.get(String.format("/api/miners/%s/%s/%d", this.clientId, this.pickaxeId, minerId)).flatMap(s -> JsonUtils.fromJson(s, this.objectMapper, new TypeReference<Miners.Miner>(){}));
    }

    @Override
    public Optional<Miners.Miner> update(int minerId, String name, String apiIp, String platform, String minerType, String serial, boolean compress) {
        Optional<Miners.Miner> result = Optional.empty();
        try {
            Optional<String> response;
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", name);
            args.put("platform", platform);
            args.put("minerType", minerType);
            if (apiIp != null) {
                args.put("apiIp", apiIp);
            }
            if (serial != null) {
                args.put("serial", serial);
            }
            if ((response = this.webUtil.put(String.format("/api/miners/%s/%s/%d", this.clientId, this.pickaxeId, minerId), this.objectMapper.writeValueAsString(args), compress)).isPresent()) {
                result = JsonUtils.fromJson(response.get(), this.objectMapper, new TypeReference<Miners.Miner>(){});
            }
        }
        catch (JsonProcessingException e) {
            LOG.warn("Exception occurred while parsing json", (Throwable)e);
        }
        return result;
    }
}

