/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.deployment.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/deployment/createPipeline/0.1.0")
public class CreatePipeline
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreatePipeline.class);

    protected String getCloudEventType() {
        return "PipelineCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String pipelineVersion;
        String pipelineName;
        String platformId;
        String hostId = (String)map.get("hostId");
        String pipelineId = dbProvider.getPipelineId(hostId, platformId = (String)map.get("platformId"), pipelineName = (String)map.get("pipelineName"), pipelineVersion = (String)map.get("pipelineVersion"));
        if (pipelineId != null) {
            map.put("pipelineId", pipelineId);
        } else {
            map.put("pipelineId", UuidUtil.getUUID().toString());
        }
        return Success.of(map);
    }
}

