
package net.lightapi.portal.instance.command.handler;

import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * createInstanceAppApi is a command side handler to create an application API for an instance.
*/
@ServiceHandler(id="lightapi.net/instance/createInstanceAppApi/0.1.0")
public class CreateInstanceAppApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstanceAppApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_APP_API_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
