
package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * delete an instance app for a gateway instance within a host.
*/
@ServiceHandler(id="lightapi.net/instance/deleteInstanceApi/0.1.0")
public class DeleteInstanceApi extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInstanceApi.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_API_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
