package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Lock an instance for the host so that it cannot be mutated
 */
@ServiceHandler(id="lightapi.net/instance/lockInstance/0.1.0")
public class LockInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(LockInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_LOCKED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
