package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Clones a source instance into target instance
 */
@ServiceHandler(id="lightapi.net/instance/cloneInstance/0.1.0")
public class CloneInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CloneInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_CLONED_EVENT;
    }

    @Override
    protected String getCloudEventAggregateId(Map<String, Object> map) {
        return (String) map.get("targetInstanceId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
