/*
 * Decompiled with CFR 0.152.
 */
package net.mst.utilities.json;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Set;
import net.mst.utilities.json.JsonArray;
import net.mst.utilities.json.Parser;

public class JsonObject {
    private File sourceFile = null;
    private String name = "jsonFile";
    private HashMap<String, Object> data;

    public JsonObject() {
        this.data = new HashMap();
    }

    public JsonObject(String Name) {
        this.data = new HashMap();
        this.name = Name;
    }

    private JsonObject(File file) {
        this.sourceFile = file;
    }

    public static JsonObject ofPath(File Path2) {
        if (!Path2.exists()) {
            Path2.getParentFile().mkdirs();
            JsonObject object = new JsonObject(Path2);
            if (Path2.isDirectory()) {
                Path2.mkdirs();
            }
            if (Path2.isFile()) {
                try {
                    Path2.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                object.save(Path2);
            }
            return object;
        }
        if (Path2.isFile()) {
            Object jsonString = "";
            Scanner fileScanner = null;
            try {
                fileScanner = new Scanner(Path2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            while (fileScanner.hasNextLine()) {
                jsonString = (String)jsonString + fileScanner.nextLine();
            }
            return new Parser().parse((String)jsonString).setSource(Path2);
        }
        return null;
    }

    public void save() {
        if (this.sourceFile != null) {
            this.save(this.sourceFile);
        }
    }

    public void save(File File2) {
        File jsonFile = File2;
        if (jsonFile.isDirectory()) {
            for (int i = 0; i >= 0; ++i) {
                File newFile;
                Object fileName = this.name;
                if (i > 0) {
                    fileName = (String)fileName + i;
                }
                if ((newFile = new File(jsonFile + "/" + (String)fileName + ".json")).exists()) continue;
                jsonFile = newFile;
                newFile.getParentFile().mkdirs();
                try {
                    newFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        try {
            FileWriter fw = new FileWriter(jsonFile, false);
            fw.write(new Parser().parse(this));
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HashMap<String, Object> getHash() {
        return this.data;
    }

    public JsonObject setName(String Name) {
        this.name = Name;
        return this;
    }

    public JsonObject setSource(File File2) {
        this.sourceFile = File2;
        return this;
    }

    public JsonObject setValue(String Key, Object Value) {
        this.data.put(Key, Value);
        return this;
    }

    public JsonObject removeValue(String Key) {
        if (this.data.containsKey(Key)) {
            this.data.remove(Key);
        }
        return this;
    }

    public Boolean containsKey(String Key) {
        if (this.data.containsKey(Key)) {
            return true;
        }
        return false;
    }

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public <T> T get(String Key) {
        if (this.data.containsKey(Key)) {
            return (T)this.data.get(Key);
        }
        return null;
    }

    public Object getObject(String Key) {
        if (this.data.containsKey(Key)) {
            return this.data.get(Key);
        }
        return null;
    }

    public String getString(String Key) {
        if (this.data.containsKey(Key)) {
            return String.valueOf(this.data.get(Key));
        }
        return null;
    }

    public Integer getInteger(String Key) {
        if (this.data.containsKey(Key)) {
            return (Integer)this.data.get(Key);
        }
        return null;
    }

    public Long getLong(String Key) {
        if (this.data.containsKey(Key)) {
            return (Long)this.data.get(Key);
        }
        return null;
    }

    public Boolean getBoolean(String Key) {
        if (this.data.containsKey(Key)) {
            return (Boolean)this.data.get(Key);
        }
        return null;
    }

    public JsonObject getJsonObject(String Key) {
        if (this.data.containsKey(Key)) {
            return (JsonObject)this.data.get(Key);
        }
        return null;
    }

    public JsonArray getArray(String Key) {
        if (this.data.containsKey(Key)) {
            return (JsonArray)this.data.get(Key);
        }
        return null;
    }

    public void addaptive(JsonObject JsonObject2) {
        if (!JsonObject2.isEmpty()) {
            JsonObject2.getKeys().forEach(key -> this.data.put((String)key, JsonObject2.get((String)key)));
        }
    }
}

