/*
 * Decompiled with CFR 0.152.
 */
package net.mst.utilities.json;

import net.mst.utilities.json.JsonArray;
import net.mst.utilities.json.JsonObject;

public class Parser {
    private String JsonString = null;
    private JsonObject JsonObject = null;
    private int currentPos = 0;
    private String name = "jsonFile";

    public Parser() {
    }

    public Parser(String Name) {
        this.name = Name;
    }

    public JsonObject parse(String JsonString) {
        this.JsonString = JsonString;
        this.currentPos = 0;
        while (this.currentPos < JsonString.length()) {
            String character = String.valueOf(JsonString.charAt(this.currentPos));
            if (character.equals("{")) {
                this.JsonObject = this.analyseObject(this.currentPos);
            }
            ++this.currentPos;
        }
        return this.JsonObject.setName(this.name);
    }

    public String parse(JsonObject JsonObject2) {
        this.JsonObject = JsonObject2;
        return this.getObject(JsonObject2);
    }

    private JsonObject analyseObject(Integer current) {
        JsonObject object = new JsonObject();
        boolean structure = false;
        Object name = "";
        for (int i = current.intValue(); i < this.JsonString.length(); ++i) {
            String character = String.valueOf(this.JsonString.charAt(i));
            if (character.equals("\"") && !this.getLast(i).equals("\\")) {
                if (!structure) {
                    structure = true;
                    continue;
                }
                if (structure) {
                    structure = false;
                    Object tObject = this.analyseValue(i, false);
                    object.setValue((String)name, tObject);
                    i = this.currentPos;
                    name = "";
                    continue;
                }
            }
            if (structure) {
                name = (String)name + character;
                continue;
            }
            if (!character.equals("}")) continue;
            this.currentPos = i;
            return object;
        }
        return object;
    }

    private Object analyseValue(Integer cur, Boolean skipReady) {
        Boolean ready = skipReady;
        Object tString = "";
        boolean structure = false;
        Integer start = cur;
        for (int i = cur.intValue(); i < this.JsonString.length(); ++i) {
            String character = String.valueOf(this.JsonString.charAt(i));
            if (ready.booleanValue()) {
                if (character.equals("\"") && !this.getLast(i).equals("\\")) {
                    if (!structure) {
                        structure = true;
                        continue;
                    }
                    if (structure) {
                        this.currentPos = i;
                        return tString;
                    }
                }
                if (structure) {
                    tString = (String)tString + character;
                    continue;
                }
                if (character.equals("{")) {
                    this.currentPos = i;
                    return this.analyseObject(this.currentPos);
                }
                if (character.equals("[")) {
                    this.currentPos = i;
                    return this.analyseArray(this.currentPos);
                }
                if (character.equals(",") | character.equals("}") | character.equals("]")) {
                    String value = this.JsonString.substring(start, i).replace(" ", "");
                    if (value.equals("false")) {
                        this.currentPos = i - 1;
                        return Boolean.FALSE;
                    }
                    if (value.equals("true")) {
                        this.currentPos = i - 1;
                        return Boolean.TRUE;
                    }
                    if (value.equals("null")) {
                        this.currentPos = i - 1;
                        return null;
                    }
                    if (this.isNumber(value)) {
                        this.currentPos = i - 1;
                        return Integer.parseInt(value);
                    }
                    this.currentPos = i - 1;
                    return null;
                }
            }
            if (!character.equals(":")) continue;
            ready = true;
            start = i + 1;
        }
        return null;
    }

    private JsonArray analyseArray(Integer cur) {
        JsonArray array = new JsonArray();
        for (int i = cur.intValue(); i < this.JsonString.length(); ++i) {
            String character = String.valueOf(this.JsonString.charAt(i));
            if (character.equals("[")) {
                Object object = this.analyseValue(i + 1, true);
                if (object == null) {
                    return array;
                }
                array.addValue(object);
                i = this.currentPos;
                continue;
            }
            if (character.equals(",")) {
                array.addValue(this.analyseValue(i + 1, true));
                i = this.currentPos;
                continue;
            }
            if (!character.equals("]")) continue;
            this.currentPos = i;
            return array;
        }
        return array;
    }

    private String getLast(Integer current) {
        if (current.equals(0)) {
            return "";
        }
        return String.valueOf(this.JsonString.charAt(current - 1));
    }

    private boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String getObject(JsonObject JsonObject2) {
        Object main = "{";
        int i = 0;
        for (String key : JsonObject2.getKeys()) {
            if (++i > 1) {
                main = (String)main + ", ";
            }
            if (JsonObject2.getObject(key) instanceof String) {
                main = (String)main + "\"" + key + "\":\"" + String.valueOf(JsonObject2.getObject(key)) + "\"";
                continue;
            }
            if (JsonObject2.getObject(key) instanceof Integer) {
                main = (String)main + "\"" + key + "\":" + (Integer)JsonObject2.get(key);
                continue;
            }
            if (JsonObject2.getObject(key) instanceof Boolean) {
                main = (String)main + "\"" + key + "\":" + (Boolean)JsonObject2.get(key);
                continue;
            }
            if (JsonObject2.getObject(key) instanceof JsonObject) {
                main = (String)main + "\"" + key + "\":" + this.getObject(JsonObject2.getJsonObject(key));
            }
            if (!(JsonObject2.getObject(key) instanceof JsonArray)) continue;
            main = (String)main + "\"" + key + "\":" + this.getArray(JsonObject2.getArray(key));
        }
        main = (String)main + "}";
        return main;
    }

    private String getArray(JsonArray JsonArray2) {
        Object sub = "[";
        int i = 0;
        for (Object element : JsonArray2.get()) {
            if (++i > 1) {
                sub = (String)sub + ", ";
            }
            if (element instanceof String) {
                sub = (String)sub + "\"" + String.valueOf(element) + "\"";
            }
            if (element instanceof Integer) {
                sub = (String)sub + (Integer)element;
            }
            if (element instanceof Boolean) {
                sub = (String)sub + (Boolean)element;
            }
            if (element instanceof JsonObject) {
                sub = (String)sub + this.getObject((JsonObject)element);
            }
            if (!(element instanceof JsonArray)) continue;
            sub = (String)sub + this.getArray((JsonArray)element);
        }
        sub = (String)sub + "]";
        return sub;
    }
}

