/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Optional;
import net.quedex.api.market.PriceQuantity;

public class Quotes {
    private final int instrumentId;
    private final BigDecimal last;
    private final int lastQuantity;
    private final BigDecimal bid;
    private final Integer bidQuantity;
    private final BigDecimal ask;
    private final Integer askQuantity;
    private final int volume;
    private final int openInterest;

    @JsonCreator
    public Quotes(@JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="last") BigDecimal last, @JsonProperty(value="last_quantity") int lastQuantity, @JsonProperty(value="bid") BigDecimal bid, @JsonProperty(value="bid_quantity") Integer bidQuantity, @JsonProperty(value="ask") BigDecimal ask, @JsonProperty(value="ask_quantity") Integer askQuantity, @JsonProperty(value="volume") int volume, @JsonProperty(value="open_interest") int openInterest) {
        Preconditions.checkArgument((last.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"last=%s <= 0", (Object[])new Object[]{last});
        Preconditions.checkArgument((lastQuantity >= 0 ? 1 : 0) != 0, (String)"lastQuantity=%s < 0", (Object[])new Object[]{lastQuantity});
        Preconditions.checkArgument((volume >= 0 ? 1 : 0) != 0, (String)"volume=%s < 0", (Object[])new Object[]{volume});
        Preconditions.checkArgument((bid == null || bid.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"bid=%s <= 0", (Object[])new Object[]{bid});
        Preconditions.checkArgument((bidQuantity == null || bidQuantity > 0 ? 1 : 0) != 0, (String)"bidQuantity=%s <= 0", (Object[])new Object[]{bidQuantity});
        Preconditions.checkArgument((ask == null || ask.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"ask=%s <= 0", (Object[])new Object[]{ask});
        Preconditions.checkArgument((askQuantity == null || askQuantity > 0 ? 1 : 0) != 0, (String)"askQuantity=%s <= 0", (Object[])new Object[]{askQuantity});
        Preconditions.checkArgument((openInterest >= 0 ? 1 : 0) != 0, (String)"openInterest=%s < 0", (Object[])new Object[]{openInterest});
        this.instrumentId = instrumentId;
        this.last = last;
        this.lastQuantity = lastQuantity;
        this.bid = bid;
        this.bidQuantity = bidQuantity;
        this.ask = ask;
        this.askQuantity = askQuantity;
        this.volume = volume;
        this.openInterest = openInterest;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public int getLastQuantity() {
        return this.lastQuantity;
    }

    public Optional<PriceQuantity> getBid() {
        return this.bidQuantity == null ? Optional.empty() : Optional.of(new PriceQuantity(this.bid, this.bidQuantity));
    }

    public Optional<PriceQuantity> getAsk() {
        return this.askQuantity == null ? Optional.empty() : Optional.of(new PriceQuantity(this.ask, this.askQuantity));
    }

    public int getVolume() {
        return this.volume;
    }

    public int getOpenInterest() {
        return this.openInterest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quotes quotes = (Quotes)o;
        return this.instrumentId == quotes.instrumentId && this.lastQuantity == quotes.lastQuantity && this.volume == quotes.volume && this.openInterest == quotes.openInterest && Objects.equal((Object)this.last, (Object)quotes.last) && Objects.equal((Object)this.bid, (Object)quotes.bid) && Objects.equal((Object)this.bidQuantity, (Object)quotes.bidQuantity) && Objects.equal((Object)this.ask, (Object)quotes.ask) && Objects.equal((Object)this.askQuantity, (Object)quotes.askQuantity);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instrumentId, this.last, this.lastQuantity, this.bid, this.bidQuantity, this.ask, this.askQuantity, this.volume, this.openInterest});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instrumentId", this.instrumentId).add("last", (Object)this.last).add("lastQuantity", this.lastQuantity).add("bid", (Object)this.bid).add("bidQuantity", (Object)this.bidQuantity).add("ask", (Object)this.ask).add("askQuantity", (Object)this.askQuantity).add("volume", this.volume).add("openInterest", this.openInterest).toString();
    }
}

