/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.market.StreamFailureListener;
import net.quedex.api.pgp.BcEncryptor;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPExceptionBase;
import net.quedex.api.user.OrderSpec;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMessageSender.class);
    private static final ObjectMapper OBJECT_MAPPER = MessageReceiver.OBJECT_MAPPER;
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private final WebSocketClient webSocketClient;
    private final BcEncryptor encryptor;
    private final long accountId;
    private final int nonceGroup;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private volatile StreamFailureListener streamFailureListener;
    private volatile long nonce;

    UserMessageSender(WebSocketClient webSocketClient, long accountId, int nonceGroup, BcPublicKey publicKey, BcPrivateKey privateKey) {
        Preconditions.checkArgument((nonceGroup >= 0 ? 1 : 0) != 0, (String)"nonceGroup=%s < 0", (Object[])new Object[]{nonceGroup});
        Preconditions.checkArgument((accountId > 0L ? 1 : 0) != 0, (String)"accountId=%s <= 0", (Object[])new Object[]{accountId});
        this.webSocketClient = (WebSocketClient)Preconditions.checkNotNull((Object)webSocketClient, (Object)"null webSocketClient");
        this.encryptor = new BcEncryptor(publicKey, privateKey);
        this.accountId = accountId;
        this.nonceGroup = nonceGroup;
    }

    void registerStreamFailureListener(StreamFailureListener streamFailureListener) {
        this.streamFailureListener = streamFailureListener;
    }

    void setStartNonce(long startNonce) {
        LOGGER.debug("setStartNonce({})", (Object)startNonce);
        this.nonce = startNonce;
    }

    void sendGetLastNonce() throws CommunicationException {
        try {
            this.sendMessage(OBJECT_MAPPER.createObjectNode().put("type", "get_last_nonce").put("nonce_group", this.nonceGroup));
        }
        catch (JsonProcessingException | PGPExceptionBase e) {
            throw new CommunicationException("Error sending get_last_nonce", e);
        }
    }

    void sendSubscribe() {
        this.sendNoncedMessage(OBJECT_MAPPER.createObjectNode().put("type", "subscribe"));
    }

    void sendOrderSpec(OrderSpec orderSpec) {
        this.sendNoncedMessage((ObjectNode)OBJECT_MAPPER.valueToTree((Object)orderSpec));
    }

    void sendBatch(List<OrderSpec> batch) {
        ObjectNode messageJson = (ObjectNode)OBJECT_MAPPER.createObjectNode().put("type", "batch").set("batch", OBJECT_MAPPER.valueToTree(batch));
        this.sendNoncedMessage(messageJson);
    }

    void stop() {
        this.executor.shutdown();
    }

    private void sendNoncedMessage(ObjectNode jsonMessage) {
        this.executor.execute(() -> {
            jsonMessage.put("nonce", this.getNonce()).put("nonce_group", this.nonceGroup);
            try {
                this.sendMessage(jsonMessage);
            }
            catch (Exception e) {
                this.onError(new CommunicationException("Error sending message", e));
            }
        });
    }

    private long getNonce() {
        return ++this.nonce;
    }

    private void sendMessage(ObjectNode jsonMessage) throws JsonProcessingException, PGPExceptionBase {
        jsonMessage.put("account_id", this.accountId);
        String messageStr = OBJECT_WRITER.writeValueAsString((Object)jsonMessage);
        this.webSocketClient.send(this.encryptor.encrypt(messageStr, true));
        LOGGER.trace("sendMessage({})", (Object)messageStr);
    }

    private void onError(Exception e) {
        LOGGER.warn("onError({})", (Throwable)e);
        StreamFailureListener streamFailureListener = this.streamFailureListener;
        if (streamFailureListener != null) {
            streamFailureListener.onStreamFailure(e);
        }
    }
}

