/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class AccountState {
    private final BigDecimal balance;
    private final BigDecimal freeBalance;
    private final BigDecimal totalInitialMargin;
    private final BigDecimal totalMaintenanceMargin;
    private final BigDecimal totalLockedForOrders;
    private final BigDecimal totalUnsettledPnL;
    private final BigDecimal totalPendingWithdrawal;
    private final Status status;

    @JsonCreator
    public AccountState(@JsonProperty(value="balance") BigDecimal balance, @JsonProperty(value="free_balance") BigDecimal freeBalance, @JsonProperty(value="total_initial_margin") BigDecimal totalInitialMargin, @JsonProperty(value="total_maintenance_margin") BigDecimal totalMaintenanceMargin, @JsonProperty(value="total_unsettled_pnl") BigDecimal totalUnsettledPnL, @JsonProperty(value="total_locked_for_orders") BigDecimal totalLockedForOrders, @JsonProperty(value="total_pending_withdrawal") BigDecimal totalPendingWithdrawal, @JsonProperty(value="account_status") Status status) {
        this.balance = (BigDecimal)Preconditions.checkNotNull((Object)balance, (Object)"null balance");
        this.freeBalance = (BigDecimal)Preconditions.checkNotNull((Object)freeBalance, (Object)"null freeBalance");
        this.totalInitialMargin = (BigDecimal)Preconditions.checkNotNull((Object)totalInitialMargin, (Object)"null totalInitialMargin");
        this.totalMaintenanceMargin = (BigDecimal)Preconditions.checkNotNull((Object)totalMaintenanceMargin, (Object)"null totalMaintenanceMargin");
        this.totalUnsettledPnL = (BigDecimal)Preconditions.checkNotNull((Object)totalUnsettledPnL, (Object)"null totalUnsettledPnL");
        this.totalLockedForOrders = (BigDecimal)Preconditions.checkNotNull((Object)totalLockedForOrders, (Object)"null totalLockedForOrders");
        this.totalPendingWithdrawal = (BigDecimal)Preconditions.checkNotNull((Object)totalPendingWithdrawal, (Object)"null totalPendingWithdrawal");
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"null status"));
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public BigDecimal getFreeBalance() {
        return this.freeBalance;
    }

    public BigDecimal getTotalInitialMargin() {
        return this.totalInitialMargin;
    }

    public BigDecimal getTotalMaintenanceMargin() {
        return this.totalMaintenanceMargin;
    }

    public BigDecimal getTotalLockedForOrders() {
        return this.totalLockedForOrders;
    }

    public BigDecimal getTotalUnsettledPnL() {
        return this.totalUnsettledPnL;
    }

    public BigDecimal getTotalPendingWithdrawal() {
        return this.totalPendingWithdrawal;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountState that = (AccountState)o;
        return Objects.equal((Object)this.balance, (Object)that.balance) && Objects.equal((Object)this.freeBalance, (Object)that.freeBalance) && Objects.equal((Object)this.totalInitialMargin, (Object)that.totalInitialMargin) && Objects.equal((Object)this.totalMaintenanceMargin, (Object)that.totalMaintenanceMargin) && Objects.equal((Object)this.totalLockedForOrders, (Object)that.totalLockedForOrders) && Objects.equal((Object)this.totalUnsettledPnL, (Object)that.totalUnsettledPnL) && Objects.equal((Object)this.totalPendingWithdrawal, (Object)that.totalPendingWithdrawal) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.balance, this.freeBalance, this.totalInitialMargin, this.totalMaintenanceMargin, this.totalLockedForOrders, this.totalUnsettledPnL, this.totalPendingWithdrawal, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("balance", (Object)this.balance).add("freeBalance", (Object)this.freeBalance).add("totalInitialMargin", (Object)this.totalInitialMargin).add("totalMaintenanceMargin", (Object)this.totalMaintenanceMargin).add("totalLockedForOrders", (Object)this.totalLockedForOrders).add("totalUnsettledPnL", (Object)this.totalUnsettledPnL).add("totalPendingWithdrawal", (Object)this.totalPendingWithdrawal).add("status", (Object)this.status).toString();
    }

    public static enum Status {
        ACTIVE,
        MARGIN_CALL,
        LIQUIDATION;


        @JsonCreator
        private static Status deserialize(String value) {
            return Status.valueOf(value.toUpperCase());
        }
    }
}

