/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.common;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.market.StreamFailureListener;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;

public class WebsocketStream<T extends MessageReceiver> {
    private final Logger logger;
    protected final WebSocketClient webSocketClient;
    private final ExecutorService webSocketClientFactoryExec;
    protected final T messageReceiver;
    private volatile StreamFailureListener streamFailureListener;

    protected WebsocketStream(final Logger logger, final String streamUrl, T messageReceiver) {
        this.webSocketClient = new WebSocketClient(URI.create(streamUrl), (Draft)new Draft_17()){

            public void onOpen(ServerHandshake handshakedata) {
                logger.info("Websocket opened with url={}, httpStatus={}, httpStatusMessage={}", new Object[]{streamUrl, handshakedata.getHttpStatus(), handshakedata.getHttpStatusMessage()});
            }

            public void onMessage(String message) {
                WebsocketStream.this.processMessage(message);
            }

            public void onClose(int code, String reason, boolean remote) {
                if (remote) {
                    WebsocketStream.this.onError(new CommunicationException("Websocket closed with code=" + code + ", reason=" + reason));
                } else {
                    logger.info("Websocket closed with code={}, reason={}", (Object)code, (Object)reason);
                }
            }

            public void onError(Exception ex) {
                WebsocketStream.this.onError(new CommunicationException("Websocket error", ex));
            }
        };
        this.webSocketClientFactoryExec = Executors.newSingleThreadExecutor();
        if (streamUrl.startsWith("wss")) {
            this.initSsl();
        }
        this.messageReceiver = (MessageReceiver)Preconditions.checkNotNull(messageReceiver, (Object)"null messageReceiver");
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"null logger");
    }

    private void initSsl() {
        try {
            SSLContext ssl = SSLContext.getInstance("TLS");
            ssl.init(null, null, null);
            DefaultSSLWebSocketClientFactory webSocketClientFactory = new DefaultSSLWebSocketClientFactory(ssl, this.webSocketClientFactoryExec);
            this.webSocketClient.setWebSocketFactory((WebSocketClient.WebSocketClientFactory)webSocketClientFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error initialising SSL", e);
        }
    }

    public void registerStreamFailureListener(StreamFailureListener streamFailureListener) {
        this.streamFailureListener = streamFailureListener;
        ((MessageReceiver)this.messageReceiver).registerStreamFailureListener(streamFailureListener);
    }

    public void start() throws CommunicationException {
        this.logger.trace("Starting");
        try {
            this.webSocketClient.connectBlocking();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.logger.info("Started");
    }

    public void stop() throws CommunicationException {
        this.logger.trace("Stopping");
        this.webSocketClient.close();
        this.webSocketClient.getConnection().closeConnection(1000, "");
        try {
            this.webSocketClient.closeBlocking();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.webSocketClientFactoryExec.shutdown();
        this.logger.info("Stopped");
    }

    private void processMessage(String message) {
        ((MessageReceiver)this.messageReceiver).processMessage(message);
    }

    private void onError(Exception e) {
        StreamFailureListener streamFailureListener = this.streamFailureListener;
        if (streamFailureListener != null) {
            streamFailureListener.onStreamFailure(e);
        }
    }
}

