/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Optional;

public final class Instrument {
    private static final int SETTLEMENT_HOUR_UTC_MILLIS = 28800000;
    private final int instrumentId;
    private final String symbol;
    private final Type type;
    private final BigDecimal tickSize;
    private final long issueDate;
    private final long expirationDate;
    private final String underlyingSymbol;
    private final int notionalAmount;
    private final BigDecimal feeFraction;
    private final BigDecimal takerToMakerFeeFraction;
    private final BigDecimal initialMarginFraction;
    private final BigDecimal maintenanceMarginFraction;
    private final BigDecimal strike;
    private final OptionType optionType;

    @JsonCreator
    public Instrument(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="type") Type type, @JsonProperty(value="option_type") OptionType optionType, @JsonProperty(value="tick_size") BigDecimal tickSize, @JsonProperty(value="issue_date") long issueDate, @JsonProperty(value="expiration_date") long expirationDate, @JsonProperty(value="underlying_symbol") String underlyingSymbol, @JsonProperty(value="notional_amount") int notionalAmount, @JsonProperty(value="fee") BigDecimal feeFraction, @JsonProperty(value="taker_to_maker") BigDecimal takerToMakerFraction, @JsonProperty(value="initial_margin") BigDecimal initialMarginFraction, @JsonProperty(value="maintenance_margin") BigDecimal maintenanceMarginFraction, @JsonProperty(value="strike") BigDecimal strike) {
        Preconditions.checkArgument((!symbol.isEmpty() ? 1 : 0) != 0, (Object)"Empty symbol");
        Preconditions.checkArgument((tickSize.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"tickSize=%s <=0", (Object[])new Object[]{tickSize});
        Preconditions.checkArgument((issueDate > 0L ? 1 : 0) != 0, (String)"issueDate=%s <= 0", (Object[])new Object[]{issueDate});
        Preconditions.checkArgument((expirationDate > issueDate ? 1 : 0) != 0, (String)"expirationDate=%s <= %s=issueDate", (Object[])new Object[]{expirationDate, issueDate});
        Preconditions.checkArgument((!underlyingSymbol.isEmpty() ? 1 : 0) != 0, (Object)"Empty underlyingSymbol");
        Preconditions.checkArgument((notionalAmount > 0 ? 1 : 0) != 0, (String)"notionalAmount=%s <= 0", (Object[])new Object[]{notionalAmount});
        Preconditions.checkArgument((feeFraction.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"feeFraction=%s < 0", (Object[])new Object[]{takerToMakerFraction});
        Preconditions.checkArgument((takerToMakerFraction.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"takerToMaker=%s < 0", (Object[])new Object[]{takerToMakerFraction});
        Preconditions.checkArgument((initialMarginFraction.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"initialMarginFraction=%s < 0", (Object[])new Object[]{initialMarginFraction});
        Preconditions.checkArgument((maintenanceMarginFraction.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"maintenanceMarginFraction=%s < 0", (Object[])new Object[]{maintenanceMarginFraction});
        this.symbol = symbol;
        this.instrumentId = instrumentId;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"null instrumentType"));
        this.tickSize = tickSize;
        this.issueDate = issueDate;
        this.expirationDate = expirationDate;
        this.underlyingSymbol = underlyingSymbol;
        this.notionalAmount = notionalAmount;
        this.feeFraction = feeFraction;
        this.takerToMakerFeeFraction = takerToMakerFraction;
        this.initialMarginFraction = initialMarginFraction;
        this.maintenanceMarginFraction = maintenanceMarginFraction;
        if (this.type == Type.FUTURES) {
            Preconditions.checkArgument((strike == null ? 1 : 0) != 0, (Object)"Expected null strike");
            Preconditions.checkArgument((optionType == null ? 1 : 0) != 0, (Object)"Expected null optionType");
            this.strike = null;
            this.optionType = null;
        } else {
            Preconditions.checkArgument((strike.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"strike=%s <= 0", (Object[])new Object[]{strike});
            this.strike = strike;
            this.optionType = (OptionType)((Object)Preconditions.checkNotNull((Object)((Object)optionType), (Object)"null optionType"));
        }
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getTickSize() {
        return this.tickSize;
    }

    public long getIssueDate() {
        return this.issueDate;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public String getUnderlyingSymbol() {
        return this.underlyingSymbol;
    }

    public int getNotionalAmount() {
        return this.notionalAmount;
    }

    public BigDecimal getFeeFraction() {
        return this.feeFraction;
    }

    public BigDecimal getTakerToMakerFeeFraction() {
        return this.takerToMakerFeeFraction;
    }

    public BigDecimal getTakerFeeFraction() {
        return this.feeFraction.add(this.takerToMakerFeeFraction);
    }

    public BigDecimal getMakerFeeFraction() {
        return this.feeFraction.subtract(this.takerToMakerFeeFraction);
    }

    public BigDecimal getInitialMarginFraction() {
        return this.initialMarginFraction;
    }

    public BigDecimal getMaintenanceMarginFraction() {
        return this.maintenanceMarginFraction;
    }

    public Optional<BigDecimal> getStrike() {
        return Optional.ofNullable(this.strike);
    }

    public Optional<OptionType> getOptionType() {
        return Optional.ofNullable(this.optionType);
    }

    public boolean isFutures() {
        return this.type == Type.FUTURES;
    }

    public boolean isTraded(long currentTimeMillis) {
        return this.issueDate < currentTimeMillis && currentTimeMillis < this.expirationDate + 28800000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instrument that = (Instrument)o;
        return this.instrumentId == that.instrumentId;
    }

    public int hashCode() {
        return Integer.hashCode(this.instrumentId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instrumentId", this.instrumentId).add("symbol", (Object)this.symbol).add("instrumentType", (Object)this.type).add("tickSize", (Object)this.tickSize).add("issueDate", this.issueDate).add("expirationDate", this.expirationDate).add("underlyingSymbol", (Object)this.underlyingSymbol).add("notionalAmount", this.notionalAmount).add("feeFraction", (Object)this.feeFraction).add("takerToMakerFeeFraction", (Object)this.takerToMakerFeeFraction).add("initialMarginFraction", (Object)this.initialMarginFraction).add("maintenanceMarginFraction", (Object)this.maintenanceMarginFraction).add("strike", (Object)this.strike).add("optionType", (Object)this.optionType).toString();
    }

    public static enum OptionType {
        CALL_EUROPEAN,
        PUT_EUROPEAN;


        @JsonCreator
        private static OptionType deserialize(String value) {
            return OptionType.valueOf(value.toUpperCase());
        }
    }

    public static enum Type {
        FUTURES,
        OPTION;


        @JsonCreator
        private static Type deserialize(String value) {
            return Type.valueOf(value.toUpperCase());
        }
    }
}

