/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import net.quedex.api.common.Config;
import net.quedex.api.common.WebsocketStream;
import net.quedex.api.market.MarketMessageReceiver;
import net.quedex.api.market.MarketStream;
import net.quedex.api.market.OrderBookListener;
import net.quedex.api.market.QuotesListener;
import net.quedex.api.market.Registration;
import net.quedex.api.market.SessionStateListener;
import net.quedex.api.market.TradeListener;
import net.quedex.api.pgp.BcPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketMarketStream
extends WebsocketStream<MarketMessageReceiver>
implements MarketStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketMarketStream.class);

    public WebsocketMarketStream(String marketStreamUrl, BcPublicKey qdxPublicKey) {
        super(LOGGER, marketStreamUrl, new MarketMessageReceiver(qdxPublicKey));
    }

    public WebsocketMarketStream(Config config) {
        this(config.getMarketStreamUrl(), config.getQdxPublicKey());
    }

    @Override
    public Registration registerOrderBookListener(OrderBookListener orderBookListener) {
        return ((MarketMessageReceiver)this.messageReceiver).registerOrderBookListener(orderBookListener);
    }

    @Override
    public Registration registerTradeListener(TradeListener tradeListener) {
        return ((MarketMessageReceiver)this.messageReceiver).registerTradeListener(tradeListener);
    }

    @Override
    public Registration registerQuotesListener(QuotesListener quotesListener) {
        return ((MarketMessageReceiver)this.messageReceiver).registerQuotesListener(quotesListener);
    }

    @Override
    public void registerAndSubscribeSessionStateListener(SessionStateListener sessionStateListener) {
        ((MarketMessageReceiver)this.messageReceiver).registerAndSubscribeSessionStateListener(sessionStateListener);
    }
}

